package com.matrix.md.sdb.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.api.ApiResult;
import com.matrix.md.sdb.entity.TableInfo;
import com.matrix.md.sdb.entity.param.DelColumnParam;
import com.matrix.md.sdb.entity.vo.DynamicDataVo;
import com.matrix.md.sdb.mapper.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * OperateDataController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/17 at 11:55 下午
 */
@Slf4j
@RestController
@RequestMapping("/opt/data")
@Api(tags = "用户动态操作数据接口")
public class OperateDataController {
    @Autowired
    private OperateSdbTableMapper operateSdbTableMapper;

    @Autowired
    private OperateDataMapper operateDataMapper;

    @Autowired
    private PlatformInfoMapper platformInfoMapper;

    @Autowired
    private DatabaseInfoMapper databaseInfoMapper;

    @Autowired
    private TableInfoMapper tableInfoMapper;

    @Autowired
    private ColumnInfoMapper columnInfoMapper;

    /**
     * 验证身份后，提供要操作的表id以及要插入的数据
     *
     * @return 成功插入数据的行数
     */
    @PostMapping
    @ApiOperation(value = "动态插入表数据", response = ApiResult.class)
    public ApiResult<List<String>> insertData(@RequestBody DynamicDataVo dataVo) {
        // TODO: 2020/5/18 这里还需要做参数验证(严格)相关的事情
        Long tableId = dataVo.getTableId();

        String tableName = tableInfoMapper.selectById(tableId).getName();

        List<Map<String, String>> dataMapList = dataVo.getData();

        // 考虑到人大进仓数据库无自增，这里手动增加id以及提前生成好分布式id(种子为tableName)
        List<String> columnNames = new ArrayList<>(dataMapList.get(0).keySet());
        columnNames.add(0, "id");
        List<List<String>> columnValues = new ArrayList<>();
        //用于返回信息返回已插入数据的id
        List<String> addedIdList = new ArrayList<>();

        for (Map<String, String> dataMap : dataMapList) {
            List<String> singleValueList = new ArrayList<>(dataMap.values());
            String nextId = new DefaultIdentifierGenerator().nextId(tableName).toString();
            addedIdList.add(nextId);
            singleValueList.add(0, nextId);
            columnValues.add(singleValueList);
        }

        int updateCount = operateDataMapper.dynamicInsertBatchData(tableName, columnNames, columnValues);


        return ApiResult.ok(addedIdList, String.format("成功插入%d条数据,数据的主键id在data字段里查看", updateCount));
    }

    @DeleteMapping
    @ApiOperation(value = "动态删除表数据", response = ApiResult.class)
    public ApiResult<Integer> deleteData(@RequestBody DelColumnParam delColumnParam) {
        //实际的逻辑需要补充的除了身份认证以外，还要这张表是不是在用户->库下(对于不同用户/库来讲,表名很明显会发生重复)
        int deleteCount = operateDataMapper.dynamicDeleteBatchData(delColumnParam);
        return ApiResult.ok(deleteCount, "删除数据成功,删除的数据量请查看data字段的值");
    }

    @GetMapping
    @ApiOperation(value = "动态查询表数据", response = ApiResult.class)
    public ApiResult findData(@RequestParam("tableName") @ApiParam(value = "要查询的表名", example = "student") String tableName) {
        List<Map<String,Object>> result = operateDataMapper.dynamicSelectData(tableName);
        return ApiResult.ok(result);
    }
}
