package com.matrix.md.sdb.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.api.ApiResult;
import com.matrix.md.common.DBSource;
import com.matrix.md.sdb.entity.TableInfo;
import com.matrix.md.sdb.entity.vo.PlatformVo;
import com.matrix.md.sdb.mapper.ColumnInfoMapper;
import com.matrix.md.sdb.mapper.TableInfoMapper;
import com.matrix.md.sdb.service.IOperateTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * OperaTableMapper.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/15 at 2:27 下午
 */
@Slf4j
@RestController
@RequestMapping("/opt/tables")
@Api(tags = "用户动态操作表接口")
public class OperateTableController {


    @Resource(name = "IOptTableServiceImpl")
    private IOperateTableService operateTableService;


    @Autowired
    private TableInfoMapper tableInfoMapper;


    /**
     * <p>1.读取要创建的表结构，并进行表创建</p>
     * <p>2.记录已经创建的表结构以及他们的之间的绑定关系</p>
     * <p>3.将绑定关系返回</p>
     * <p>PS: 操作1与2应当是在同一个事物下</p>
     *
     * @param platformVo 要创建表的表信息
     * @return
     */
    @PostMapping
    @ApiOperation(value = "动态创建表", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            response = TableInfo.class, responseContainer = "List")
    public ApiResult<List<TableInfo>> createTable(@RequestBody PlatformVo platformVo,
                                                  @RequestParam(value = "source", required = false) @ApiParam(value = "要操作的数据源(SDB/XDB/YDB)", example = "SDB") DBSource dbSource) {

        List<TableInfo> tableInfoResults = operateTableService.dynamicCreateTables(platformVo, dbSource);
        return ApiResult.ok(tableInfoResults);

    }

    /**
     * <p>1.删除数据库里的表结构</p>
     * <p>1.删除table_info与column中记录的表结构信息</p>
     *
     * @param tableName
     * @return
     */
    @DeleteMapping
    @ApiOperation(value = "动态删除表", response = ApiResult.class)
    public ApiResult<String> dropTable(
            @RequestParam("tableName") @ApiParam(value = "要删除的表名", example = "student") String tableName,
            @RequestParam(value = "source", required = false) @ApiParam(value = "要操作的数据源(SDB/XDB/YDB)", example = "SDB") DBSource dbSource) {
        int delColumnLines = 0;

        delColumnLines = operateTableService.dynamicDeleteTables(tableName, dbSource);

        return ApiResult.ok(String.format("成功删除了%s表以及其相关的%d列的数据", tableName, delColumnLines));
    }


    /**
     * 查询数据目录,因为是DEMO所以没有设定很严格的一些权限条件之类的
     *
     * @return
     */
    @GetMapping
    @ApiOperation(value = "查询数据目录", response = TableInfo.class, responseContainer = "List")
    public ApiResult<List<TableInfo>> findTableInfos() {
        List<TableInfo> tableInfos = tableInfoMapper.selectList(Wrappers.emptyWrapper());
        return ApiResult.ok(tableInfos);
    }
}
