package com.matrix.md.sdb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 平台信息
 *
 * @author matrix
 * @since 2020-05-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PlatformInfo对象")
@TableName(resultMap = "platformMap")
public class PlatformInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键，雪花算法生成不能为空")
    @ApiModelProperty("主键，雪花算法生成")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @NotBlank(message = "平台名不能为空")
    @ApiModelProperty("平台名")
    private String name;

    @NotNull(message = "平台类型(1为写入方平台,2为读取方平台,3为同时是写入方与读取方平台)不能为空")
    @ApiModelProperty("平台类型(1为写入方平台,2为读取方平台,3为同时是写入方与读取方平台)")
    private Integer type;

    @TableField(exist = false)
    private List<DatabaseInfo> databaseInfoList = new ArrayList<>();

}
