package com.matrix.md.sdb.entity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * DynamicColumnVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/18 at 4:36 下午
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel("用于动态删除数据接口的参数对象")
public class DelColumnParam {

    @ApiModelProperty(value = "要删除数据所属表的表名", example = "student", position = 0)
    private String tableName;

    @ApiModelProperty(value = "要删除的数据所属表的主键字段名称", example = "id", position = 1)
    private String primaryKeyName;

    @ApiModelProperty(value = "要删除的数据主键id", example = "[16,17,18]", position = 2)
    private List<Long> columnsIds;
}
