package com.matrix.md.sdb.entity.vo;

import com.matrix.md.sdb.entity.ColumnInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * ColumnVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/15 at 2:31 下午
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel("用于视图层操作的列对象，里面记录了列结构信息")
public class ColumnVo {

    @ApiModelProperty(value = "列名", example = "name")
    private String columnName;

    @ApiModelProperty(value = "列的数据类型", example = "varchar(255)")
    private String columnType;

    @ApiModelProperty(value = "该列是否允许为null,0不允许,1允许", example = "0")
    private int isNull;

    public ColumnInfo tran2Column(){
        return new ColumnInfo().setName(columnName)
                .setDataType(columnType)
                .setIsNull(isNull);
    }
}
