package com.matrix.md.sdb.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * DynamicDataVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/18 at 12:11 上午
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel("用于视图层操作的列对象，用于描述动态列的数据结构")
public class DynamicDataVo {

    @ApiModelProperty(value = "该动态数据所属的表的id", example = "123456")
    private Long tableId;

    @ApiModelProperty(value = "动态数据内容", example = "[{\"name\":\"jack\",\"age\":22},{\"name\":\"rose\",\"age\":23}]", position = 1)
    private List<Map<String, String>> data;
}
