package com.matrix.md.sdb.mapper;

import com.matrix.md.sdb.entity.param.DelColumnParam;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * OperateDataMapper.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/18 at 3:14 下午
 */
@Repository
public interface OperateDataMapper {

    /**
     * 批量动态插入数据
     * @param tableName    要动态插入数据的表名
     * @param columnNames  要插入的列的名称，要插入多列所以为集合
     * @param columnValues 要插入列的具体的数据，可能会涉及到批量插入因此是一个复式集合
     * @return 成功插入的数据行数
     */
    int dynamicInsertBatchData(@Param("tableName") String tableName,
                               @Param("columnNames") List<String> columnNames,
                               @Param("columnValues") List<List<String>> columnValues);

    /**
     * 批量动态删除数据
     * @param delColumnParam 具体查看{@link DelColumnParam}字段解释
     * @return 成功删除的数据行数
     */
    int dynamicDeleteBatchData(@Param("columnParam") DelColumnParam delColumnParam);

    /**
     * 动态查询表数据
     * @param tableName 要查询数据的表名
     * @return 以key,value的形式将结果返回
     */
    List<Map<String,Object>> dynamicSelectData(@Param("tableName") String tableName);
}
