package com.matrix.md.sdb.service;

import com.matrix.md.common.DBSource;
import com.matrix.md.sdb.entity.TableInfo;
import com.matrix.md.sdb.entity.vo.PlatformVo;

import java.util.List;

/**
 * IOperateTableService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/20 at 3:29 下午
 */
public interface IOperateTableService {
    /**
     * 动态创建表
     * @param platformVo 必须的参数
     * @param dbSource 该操作的数据源
     * @return 创表成功后的数据结构列表
     */
     List<TableInfo> dynamicCreateTables(PlatformVo platformVo, DBSource dbSource);

    /**
     * 动态删除表
     * @param tableName 要删除的表名
     * @param dbSource 要操作的数据源
     * @return 删除的表的数量
     */
    int dynamicDeleteTables(String tableName, DBSource dbSource);
}
