import Vue from 'vue'
import VueRouter from 'vue-router'
import layout from '../views/layout.vue'

Vue.use(VueRouter)

  const routes = [
  {
    path: '/',
    name: 'layout',
    component: layout,
      redirect: '/p1',
      children: [
          {
              path: '/p1',
              name: 'p1',
              component: () => import(/* webpackChunkName: "unit" */ '../views/overview.vue')
          },
          {
              path: '/p2',
              name: 'p2',
              component: () => import(/* webpackChunkName: "unit" */ '../views/projectWork.vue')
          },
          {
              path: '/p3',
              name: 'p3',
              component: () => import(/* webpackChunkName: "unit" */ '../views/todo.vue')
          },
          {
              path: '/p4',
              name: 'p4',
              component: () => import(/* webpackChunkName: "unit" */ '../views/projectFile.vue')
          },
          {
              path: '/p5',
              name: 'p5',
              component: () => import(/* webpackChunkName: "unit" */ '../views/architectureDiagram.vue')
          }
      ]
  }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
