package com.jenkins.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.persistence.*;

@Accessors(chain = true)
@Setter
@Getter
@ToString
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "user")
@ApiModel(value = "用户登录信息")
public class User {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "用户Id")
    private Integer id;
    @Column(name = "username")
    @ApiModelProperty(value = "用户名")
    private String username;
    @Column(name = "password")
    @ApiModelProperty(value = "用户密码")
    private String password;
}
