package com.jenkins.controller;

import com.jenkins.entity.User;
import com.jenkins.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.mockito.CheckReturnValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@CheckReturnValue
@RequestMapping("/users")
@Api(tags = "用户信息管理",description = "对用户信息的CRUD")
public class UserController {

    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping
    @ApiOperation(value = "查询所有用户信息")
    public ResponseEntity<List<User>> find(){
        List<User> result = userService.find();
        if (result.size() == 0) {
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @GetMapping("/{id}")
    @ApiOperation(value = "按id查询指定用户")
    public ResponseEntity<Optional<User>> findById(@PathVariable Integer id){
        Optional<User> result = userService.findById(id);
        if (id == 0 || id == null){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @PostMapping
    @ApiOperation(value = "添加用户")
    public ResponseEntity<User> insert(@RequestBody User user){
        User result = userService.insert(user);
        if (user.getId() == 0 || user.getId() == null){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @PutMapping("/{id}")
    @ApiOperation(value = "按照id修改用户信息")
    public ResponseEntity<User> update(@RequestBody User user){
        User result = userService.update(user);
        if (user.getId() == 0 || user.getId() == null){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @DeleteMapping("/{id}")
    @ApiOperation(value = "根据id删除用户")
    public ResponseEntity<Integer> delete(@PathVariable Integer id){
        userService.delete(id);
        if (id == 0 || id == null){
            return ResponseEntity.status(404).body(id);
        }else {
            return ResponseEntity.ok(id);
        }
    }
}
