package com.tykj.forecast.controller;

import com.tykj.forecast.entity.BasicsFile;
import com.tykj.forecast.entityVo.Statistics;
import com.tykj.forecast.service.IBasicsFileService;
import com.tykj.forecast.utils.FileUtils;
import com.tykj.forecast.utils.PathUrl;
import com.tykj.forecast.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import static com.tykj.forecast.utils.CalculationUtils.format;

/**
 * @author mruny
 */
@RestController
@CrossOrigin
@RequestMapping("/basicsFiles")
@Api(tags = "基础文件")
public class BasicsFileController {
    @Autowired
    private IBasicsFileService basicsFileService;

//    /**
//     * 存入公文基础识别数据
//     *
//     * @return 存入的分析结果
//     */
//    @ApiOperation("批量存入公文基础识别数据")
//    @PostMapping
//    public ResponseEntity<List<BasicsFile>> insertBasicsFile(@RequestBody List<BasicsFile> basicsFileList) {
//        List<BasicsFile> list = new ArrayList<>();
//        for (BasicsFile basicsFile : basicsFileList) {
//            basicsFile.setStatus("1");
//            list.add(basicsFile);
//        }
//        List<BasicsFile> result = basicsFileService.saveAll(list);
//        return ResponseEntity.ok(result);
//    }

    /**
     * 分页查询公文基础识别数据
     *
     * @param pageSize 当前页数
     * @param pageNum  每页多少条数据
     * @return 查询到的结果
     */
    @ApiOperation("公文基础识别数据")
    @GetMapping
    public ResponseEntity<Page<BasicsFile>> pageBasicsFile(int pageSize, int pageNum, String status) {
        Page<BasicsFile> results = basicsFileService.findByStatus(pageNum - 1, pageSize, status);
        return ResponseEntity.ok(results);
    }

    /**
     * 清空公文基础识别数据
     */
    @ApiOperation("清空公文基础识别数据")
    @PutMapping
    public ResponseEntity<List<BasicsFile>> removeRetrenchFile() {
        List<BasicsFile> basicsFiles = basicsFileService.listBasics();
        List<BasicsFile> list = new ArrayList<>();
        for (BasicsFile basicsFile : basicsFiles) {
            basicsFile.setStatus("0");
            list.add(basicsFile);
        }
        List<BasicsFile> results = basicsFileService.saveAll(list);
        return ResponseEntity.ok(results);
    }

    /**
     * 公文基础统计
     */
    @ApiOperation("公文基础统计")
    @GetMapping("/statistics")
    public Map<String, List<Statistics>> basicsStatistics() {
        Map<String, List<Statistics>> map = new HashMap<>();
        List<BasicsFile> listBasics = basicsFileService.listBasics();
        Long count = basicsFileService.count();
        /*
         * 文件总数
         */
        List<Statistics> listSize = new ArrayList<>();
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        int fileSize = files.size();
        Statistics statisticsSize = new Statistics();
        statisticsSize.setValue(String.valueOf(fileSize));
        statisticsSize.setName("size");
        listSize.add(statisticsSize);
        map.put("size", listSize);
        /*
         * 成功文件数
         */
        List<Statistics> listSuccessSize = new ArrayList<>();
        Statistics statisticsSuccessSize = new Statistics();
        statisticsSuccessSize.setValue(String.valueOf(count));
        statisticsSuccessSize.setName("successSize");
        listSuccessSize.add(statisticsSuccessSize);
        map.put("successSize", listSuccessSize);
        /*
         * 文件分类统计associationCategory
         */
        List<Statistics> listType = new ArrayList<>();
        Map<String, List<BasicsFile>> mapType = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getAssociationCategory()) && basicsFile.getAssociationCategory() != null)
                .collect(Collectors.groupingBy(BasicsFile::getAssociationCategory));
        Set<String> types = mapType.keySet();
        Statistics statisticsTypeBriefing = new Statistics("0", "简报专报");
        //会议
        Statistics statisticsTypeMeeting = new Statistics("0", "报表");
        Statistics statisticsTypeSummary = new Statistics("0", "总结汇报");
        //报表
        Statistics statisticsTypeReport = new Statistics("0", "会议");
        Statistics statisticsTypeApp = new Statistics("0", "App");
        Statistics statisticsTypeOther = new Statistics("0", "其他");
        for (String type : types) {
            if ("0".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeBriefing.setValue(String.valueOf(size));
                statisticsTypeBriefing.setName("简报专报");
            }
            //会议
            if ("1".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeMeeting.setValue(String.valueOf(size));
                statisticsTypeMeeting.setName("报表");
            }
            if ("2".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeSummary.setValue(String.valueOf(size));
                statisticsTypeSummary.setName("总结汇报");
            }
            //报表
            if ("3".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeReport.setValue(String.valueOf(size));
                statisticsTypeReport.setName("会议");
            }
            if ("4".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeApp.setValue(String.valueOf(size));
                statisticsTypeApp.setName("App");
            }
            if ("5".equals(type)) {
                long size = mapType.get(type).size();
                statisticsTypeOther.setValue(String.valueOf(size));
                statisticsTypeOther.setName("其他");
            }
        }
        listType.add(statisticsTypeApp);
        listType.add(statisticsTypeMeeting);
        listType.add(statisticsTypeBriefing);
        listType.add(statisticsTypeSummary);
        listType.add(statisticsTypeReport);
        listType.add(statisticsTypeOther);
        map.put("associationCategory", listType);
        /*
         * 发文统计(单位)主体发文单位bodyIssuingUnit
         */
        List<Statistics> listBodyIssuingUnit = new ArrayList<>();
        Map<String, List<BasicsFile>> mapMainUnit = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getBodyIssuingUnit()) && basicsFile.getBodyIssuingUnit() != null)
                .collect(Collectors.groupingBy(BasicsFile::getBodyIssuingUnit));
        Set<String> mainUnits = mapMainUnit.keySet();
        for (String mainUnit : mainUnits) {
            long size = mapMainUnit.get(mainUnit).size();
            Statistics statisticsMainUnit = new Statistics();
            statisticsMainUnit.setValue(String.valueOf(size));
            statisticsMainUnit.setName(mainUnit);
            listBodyIssuingUnit.add(statisticsMainUnit);
        }
        map.put("bodyIssuingUnit", listBodyIssuingUnit);
        /*
         * 发文时间统计  月份
         */
        LocalDateTime now = LocalDateTime.now();
        String nowYear = String.valueOf(now.getYear() - 1);
        List<BasicsFile> fileList = new ArrayList<>();
        //所有发文时间
        List<BasicsFile> collectDates = listBasics.stream()
                .filter(basicsFile -> basicsFile.getIssueDate() != null && !"".equals(basicsFile.getIssueDate()))
                .collect(Collectors.toList());
        //过滤获取到今年的
        for (BasicsFile collectDate : collectDates) {
            if (collectDate != null && collectDate.getIssueDate() != null && !"".equals(collectDate.getIssueDate())) {
                String date = collectDate.getIssueDate();
                String year = StringUtil.substring(date);
                if (nowYear.equals(year)) {
                    fileList.add(collectDate);
                }
            }
        }
        //今年的文件
        List<BasicsFile> nowYearFile = fileList.stream()
                .filter(basicsFile -> basicsFile.getIssueDate() != null && !"".equals(basicsFile.getIssueDate()))
                .collect(Collectors.toList());
        List<Statistics> statisticsList = new ArrayList<>();
        for (int i = 1; i < 13; i++) {
            List<String> months = new ArrayList<>();
            for (BasicsFile basicsFile : nowYearFile) {
                if (basicsFile != null && basicsFile.getIssueDate() != null && !"".equals(basicsFile.getIssueDate())) {
                    String date = basicsFile.getIssueDate();
                    String monthDay = date.replace(nowYear + "-", "");
                    String month = StringUtil.substring(monthDay);
                    if (i < 10) {
                        if (month.equals("0" + i)) {
                            months.add(month);
                        }
                    } else {
                        if (month.equals(i + "")) {
                            months.add(month);
                        }
                    }
                }
            }
            Map<String, List<String>> collect = months.stream().collect(Collectors.groupingBy(String::toString));
            //存在的所有月份
            Set<String> strings = collect.keySet();
            Statistics statistics = new Statistics();
            statistics.setName(i + "月");
            statistics.setValue("0");
            for (String string : strings) {
                long size = collect.get(string).size();
                if (i < 10) {
                    if (string.equals("0" + i)) {
                        statistics.setValue(String.valueOf(size));
                    }
                } else {
                    if (string.equals(i + "")) {
                        statistics.setValue(String.valueOf(size));
                    }
                }
            }
            statisticsList.add(statistics);
        }
        map.put("issueData", statisticsList);
        /*
         * 关键内容频次统计
         */
        //总数据
        List<Statistics> listKeyword = new ArrayList<>();

        //公文类别
        List<BasicsFile> collectAssociationCategory = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getAssociationCategory()) && basicsFile.getAssociationCategory() != null)
                .collect(Collectors.toList());
        long sizeAssociationCategory = collectAssociationCategory.size();
        Statistics statisticsAssociationCategory = new Statistics();
        statisticsAssociationCategory.setName("公文类别");
        String numberAssociationCategory = format(sizeAssociationCategory, count);
        statisticsAssociationCategory.setValue(numberAssociationCategory);
        listKeyword.add(statisticsAssociationCategory);
        //发文字号issuedNumber
        List<BasicsFile> collectIssueNumber = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getIssueNumber()) && basicsFile.getIssueNumber() != null)
                .collect(Collectors.toList());
        long sizeIssuedNumber = collectIssueNumber.size();
        Statistics statisticsIssuedNumber = new Statistics();
        statisticsIssuedNumber.setName("发文字号");
        String numberIssuedNumber = format(sizeIssuedNumber, count);
        statisticsIssuedNumber.setValue(numberIssuedNumber);
        listKeyword.add(statisticsIssuedNumber);

        //签发人issuer
        List<BasicsFile> collectIssuePerson = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getIssuePerson()) && basicsFile.getIssuePerson() != null)
                .collect(Collectors.toList());
        long sizeIssuer = collectIssuePerson.size();
        Statistics statisticsIssuer = new Statistics();
        statisticsIssuer.setName("签发人");
        String numberIssuer = format(sizeIssuer, count);
        statisticsIssuer.setValue(numberIssuer);
        listKeyword.add(statisticsIssuer);

        //标题
        List<BasicsFile> collectTitle = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getTitle()) && basicsFile.getTitle() != null)
                .collect(Collectors.toList());
        long sizeTitle = collectTitle.size();
        Statistics statisticsTitle = new Statistics();
        statisticsTitle.setName("标题");
        String numberTitle = format(sizeTitle, count);
        statisticsTitle.setValue(numberTitle);
        listKeyword.add(statisticsTitle);

        //发文单位
        List<BasicsFile> collectIssueUnit = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getIssueUnit()) && basicsFile.getIssueUnit() != null)
                .collect(Collectors.toList());
        long sizeMainUnit = collectIssueUnit.size();
        Statistics statisticsMainUnit = new Statistics();
        statisticsMainUnit.setName("发文单位");
        String numberMainUnit = format(sizeMainUnit, count);
        statisticsMainUnit.setValue(numberMainUnit);
        listKeyword.add(statisticsMainUnit);

        //接收单位receiveUnit
        List<BasicsFile> collectAcceptUnit = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getAcceptUnit()) && basicsFile.getAcceptUnit() != null)
                .collect(Collectors.toList());
        long sizeReceiveUnit = collectAcceptUnit.size();
        Statistics statisticsReceiveUnit = new Statistics();
        statisticsReceiveUnit.setName("接收单位");
        String numberReceiveUnit = format(sizeReceiveUnit, count);
        statisticsReceiveUnit.setValue(numberReceiveUnit);
        listKeyword.add(statisticsReceiveUnit);

        //发文日期
        List<BasicsFile> collectIssueDate = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getIssueDate()) && basicsFile.getIssueDate() != null)
                .collect(Collectors.toList());
        long sizeIssueDate = collectIssueDate.size();
        Statistics statisticsIssueDate = new Statistics();
        statisticsIssueDate.setName("发文日期");
        String numberIssueDate = format(sizeIssueDate, count);
        statisticsIssueDate.setValue(numberIssueDate);
        listKeyword.add(statisticsIssueDate);

        //抄送单位copyUnit
        List<BasicsFile> collectCopyUnit = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getCopyUnit()) && basicsFile.getCopyUnit() != null)
                .collect(Collectors.toList());
        long sizeCopyUnit = collectCopyUnit.size();
        Statistics statisticsCopyUnit = new Statistics();
        statisticsCopyUnit.setName("抄送单位");
        String numberCopyUnit = format(sizeCopyUnit, count);
        statisticsCopyUnit.setValue(numberCopyUnit);
        listKeyword.add(statisticsCopyUnit);

        //印发单位replicaUnit
        List<BasicsFile> collectReplicaUnit = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getReplicaUnit()) && basicsFile.getReplicaUnit() != null)
                .collect(Collectors.toList());
        long sizeReplicaUnit = collectReplicaUnit.size();
        Statistics statisticsReplicaUnit = new Statistics();
        statisticsReplicaUnit.setName("印发单位");
        String numberReplicaUnit = format(sizeReplicaUnit, count);
        statisticsReplicaUnit.setValue(numberReplicaUnit);
        listKeyword.add(statisticsReplicaUnit);

        //印发日期replicaDate
        List<BasicsFile> collectReplicaDate = listBasics.stream()
                .filter(basicsFile -> !"".equals(basicsFile.getReplicaDate()) && basicsFile.getReplicaDate() != null)
                .collect(Collectors.toList());
        long sizeReplicaDate = collectReplicaDate.size();
        Statistics statisticsReplicaDate = new Statistics();
        statisticsReplicaDate.setName("印发日期");
        String numberReplicaDate = format(sizeReplicaDate, count);
        statisticsReplicaDate.setValue(numberReplicaDate);
        listKeyword.add(statisticsReplicaDate);
        map.put("KeywordStatistics", listKeyword);
        return map;
    }

}
