package com.tykj.forecast.controller;

import com.alibaba.fastjson.JSON;
import com.tykj.forecast.entity.BasicsFile;
import com.tykj.forecast.entity.MeetingFile;
import com.tykj.forecast.entity.RetrenchFile;
import com.tykj.forecast.service.IBasicsFileService;
import com.tykj.forecast.service.IMeetingFileService;
import com.tykj.forecast.service.IRetrenchFileService;
import com.tykj.forecast.utils.FileUtils;
import com.tykj.forecast.utils.PathUrl;
import com.tykj.forecast.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.util.List;


/**
 * @author mruny
 */
@CrossOrigin
@RestController
@RequestMapping("/import")
@Api(tags = "访问其他接口")
public class DataExcelImportController {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private IBasicsFileService basicsFileService;

    @Autowired
    private IMeetingFileService meetingFileService;

    @Autowired
    private IRetrenchFileService retrenchFileService;

    public static StatusBasicsFile statusParser = new StatusBasicsFile("0", "0", false);

    public static StatusMeetingFile statusFile = new StatusMeetingFile("0", "0", false);

    public static StatusRetrenchFile statusExtraction = new StatusRetrenchFile("0", "0", false);

    private static final String REST_URL_EXTRACTION = "http://172.18.27.31:8011/parser/v1/field_extraction";

    private static final String REST_URL_DOC_PARSER = "http://172.18.27.31:8011/parser/v1/doc_parser";

    private static final String REST_URL_FILE_CLASSIFICATION = "http://172.18.27.31:8011/parser/v1/file_classification";

    @ApiOperation("会议文件分析")
    @PostMapping("/parser")
    public String parser() {
        statusParser.setStatus(true);
        int size = 0;
        int num = 0;
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        if (files.size() != 0) {
            statusParser.setTotal(String.valueOf(files.size()));
        } else {
            statusParser.setTotal("0");
        }
        List<MeetingFile> listName = meetingFileService.listMeeting();
        if (listName != null && listName.size() != 0) {
            for (MeetingFile meetingFile : listName) {
                if (meetingFile != null && meetingFile.getCustomName() != null && !"".equals(meetingFile.getCustomName())) {
                    meetingFile.setStatus("1");
                    meetingFileService.save(meetingFile);
                    size = size + 1;
                    statusParser.setSize(String.valueOf(size));
                }
            }
            for (MeetingFile meetingFile : listName) {
                if (meetingFile != null && meetingFile.getCustomName() != null && !"".equals(meetingFile.getCustomName())) {
                    String customName = meetingFile.getCustomName();
                    if (files.size() != 0 && files != null) {
                        for (File file : files) {
                            String path = file.getPath();
                            //判断数据库中是否存在这个文件
                            if (path.equals(customName)) {
                                files.remove(file);
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (files.size() != 0 && files != null) {
            for (File file : files) {
                size = size + 1;
                statusParser.setSize(String.valueOf(size));
                MeetingFileVo meetingFileVo = new MeetingFileVo();
                BasicsFileVo basicsFileVo = new BasicsFileVo();
                //当前第几个文件
                try {
                    FileSystemResource resource = getFileSystemResource(file);
                    MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
                    param.add("my_file", resource);
                    HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity<>(param);
                    ResponseEntity<String> responseEntity1 = restTemplate.exchange(REST_URL_EXTRACTION, HttpMethod.POST, httpEntity, String.class);
                    String body1 = responseEntity1.getBody();
                    basicsFileVo = JSON.parseObject(body1, BasicsFileVo.class);
                    ResponseEntity<String> responseEntity = restTemplate.exchange(REST_URL_DOC_PARSER + "?num=" + num, HttpMethod.POST, httpEntity, String.class);
                    String body = responseEntity.getBody();
                    meetingFileVo = JSON.parseObject(body, MeetingFileVo.class);
                } catch (Error | Exception e) {
                    continue;
                }
                if (meetingFileVo != null) {
                    if (basicsFileVo != null && basicsFileVo.getTitle() != null && !"".equals(basicsFileVo.getTitle())) {
                        meetingFileVo.setFileTitle(basicsFileVo.getTitle());
                    }
                    meetingFileVo.setCustomName(file.getPath());
                    if (meetingFileVo.getNoMeetingInfo() != null && !"".equals(meetingFileVo.getNoMeetingInfo())) {
                        String replace = meetingFileVo.getNoMeetingInfo()
                                .replace("年", "-")
                                .replace("月", "-")
                                .replace("日", "");
                        meetingFileVo.setNoMeetingInfo(replace);
                    }
                    if ("1".equals(meetingFileVo.getMeetingType()) || "2".equals(meetingFileVo.getMeetingType()) || "3".equals(meetingFileVo.getMeetingType())) {
                        //解析好了存储
                        MeetingFile meetingFile = meetingFileVo.toMeetFile();
                        meetingFile.setStatus("1");
                        meetingFileService.save(meetingFile);
                    }
                }
            }
        }
        statusParser.setStatus(false);
        return "解析完成";
    }

    @ApiOperation("精简公文")
    @PostMapping("/file")
    public String file() {
        statusFile.setStatus(true);
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        if (files.size() != 0) {
            statusFile.setTotal(String.valueOf(files.size()));
        } else {
            statusFile.setTotal("0");
        }
        int size = 0;
        List<RetrenchFile> retrenchFiles = retrenchFileService.listRetrench();
        if (retrenchFiles != null && retrenchFiles.size() != 0) {
            for (RetrenchFile retrenchFile : retrenchFiles) {
                if (retrenchFile != null && retrenchFile.getCustomName() != null && !"".equals(retrenchFile.getCustomName())) {
                    retrenchFile.setStatus("1");
                    retrenchFileService.save(retrenchFile);
                    size = size + 1;
                    statusFile.setSize(String.valueOf(size));
                }
            }
            for (RetrenchFile retrenchFile : retrenchFiles) {
                if (retrenchFile != null && retrenchFile.getCustomName() != null && !"".equals(retrenchFile.getCustomName())) {
                    String customName = retrenchFile.getCustomName();
                    if (files.size() != 0 && files != null) {
                        for (File file : files) {
                            String path = file.getPath();
                            if (path.equals(customName)) {
                                files.remove(file);
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (files != null && files.size() != 0) {
            for (File file : files) {
                size = size + 1;
                statusFile.setSize(String.valueOf(size));
                RetrenchFileVo retrenchFileVo = new RetrenchFileVo();
                BasicsFileVo basicsFileVo = new BasicsFileVo();
                try {
                    FileSystemResource resource = getFileSystemResource(file);
                    MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
                    //参数
                    param.add("my_file", resource);
                    HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity<>(param);
                    ResponseEntity<String> responseEntity1 = restTemplate.exchange(REST_URL_EXTRACTION, HttpMethod.POST, httpEntity, String.class);
                    String body1 = responseEntity1.getBody();
                    basicsFileVo = JSON.parseObject(body1, BasicsFileVo.class);
                    ResponseEntity<String> responseEntity = restTemplate.exchange(REST_URL_FILE_CLASSIFICATION, HttpMethod.POST, httpEntity, String.class);
                    String body = responseEntity.getBody();
                    retrenchFileVo = JSON.parseObject(body, RetrenchFileVo.class);
                } catch (Error | Exception e) {
                    continue;
                }
                if (retrenchFileVo != null) {
                    if (basicsFileVo != null && basicsFileVo.getTitle() != null && !"".equals(basicsFileVo.getTitle())) {
                        retrenchFileVo.setTitle(basicsFileVo.getTitle());
                    }
                    retrenchFileVo.setCustomName(file.getPath());
                    //解析好了存储
                    if ("0".equals(retrenchFileVo.getFileType()) || "1".equals(retrenchFileVo.getFileType()) || "2".equals(retrenchFileVo.getFileType())) {
                        RetrenchFile retrenchFile = retrenchFileVo.toRetrenchFile();
                        retrenchFile.setStatus("1");
                        retrenchFileService.save(retrenchFile);
                    }
                }
            }
        }
        statusFile.setStatus(false);
        return "解析完成";
    }

    @ApiOperation("基础公文")
    @PostMapping("/extraction")
    public String extraction() {
        statusExtraction.setStatus(true);
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        if (files.size() != 0) {
            statusExtraction.setTotal(String.valueOf(files.size()));
        } else {
            statusExtraction.setTotal("0");
        }
        int size = 0;
        List<BasicsFile> basicsFiles = basicsFileService.listBasics();
        if (basicsFiles != null && basicsFiles.size() != 0) {
            for (BasicsFile basicsFile : basicsFiles) {
                if (basicsFile != null && basicsFile.getCustomName() != null && !"".equals(basicsFile.getCustomName())) {
                    basicsFile.setStatus("1");
                    basicsFileService.save(basicsFile);
                    size = size + 1;
                    statusExtraction.setSize(String.valueOf(size));
                }
            }
            for (BasicsFile basicsFile : basicsFiles) {
                if (basicsFile != null && basicsFile.getCustomName() != null && !"".equals(basicsFile.getCustomName())) {
                    String customName = basicsFile.getCustomName();
                    if (files != null && files.size() != 0) {
                        for (File file : files) {
                            String path = file.getPath();
                            if (path.equals(customName)) {
                                files.remove(file);
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (files != null && files.size() != 0) {
            for (File file : files) {
                size = size + 1;
                statusExtraction.setSize(String.valueOf(size));
                BasicsFileVo basicsFileVo = new BasicsFileVo();
                try {
                    FileSystemResource resource = getFileSystemResource(file);
                    MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
                    //参数
                    param.add("my_file", resource);
                    HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity<>(param);
                    ResponseEntity<String> responseEntity = restTemplate.exchange(REST_URL_EXTRACTION, HttpMethod.POST, httpEntity, String.class);
                    String body = responseEntity.getBody();
                    basicsFileVo = JSON.parseObject(body, BasicsFileVo.class);
                } catch (Error | Exception e) {
                    continue;
                }
                if (basicsFileVo != null) {
                    if (basicsFileVo.getIssueDate() != null && !"".equals(basicsFileVo.getIssueDate())) {
                        String issueDate = basicsFileVo.getIssueDate()
                                .replace("年", "-")
                                .replace("月", "-")
                                .replace("日", "");
                        basicsFileVo.setIssueDate(issueDate);
                    }
                    if (basicsFileVo.getReplicaDate() != null && !"".equals(basicsFileVo.getReplicaDate())) {
                        String replicaDate = basicsFileVo.getReplicaDate()
                                .replace("年", "-")
                                .replace("月", "-")
                                .replace("日", "");
                        basicsFileVo.setReplicaDate(replicaDate);
                    }
                    basicsFileVo.setCustomName(file.getPath());
                    basicsFileVo.setReplicaDate(basicsFileVo.getIssueDate());
                    basicsFileVo.setReplicaUnit(basicsFileVo.getIssueUnit());
                    //解析好了存储
                    BasicsFile basicsFile = basicsFileVo.toBasicsFile();
                    basicsFile.setStatus("1");
                    basicsFileService.save(basicsFile);
                }
            }
        }
        statusExtraction.setStatus(false);
        return "解析完成";
    }

    /**
     * 统计页判断是否存在数据
     * 1为公文基础识别
     * 2为会议公文分析
     * 3为重点精简文件分析
     *
     * @param i 选择的是哪个分析
     * @return 是否存在数据
     */
    @ApiOperation("是否存在数据")
    @GetMapping("/bool")
    public String status(@RequestParam String i) {
        if ("1".equals(i)) {
            List<BasicsFile> listBasics = basicsFileService.listBasics();
            if (listBasics.size() > 0) {
                if ("1".equals(listBasics.get(0).getStatus())) {
                    return "1";
                }
            }
        }
        if ("2".equals(i)) {
            List<MeetingFile> listMeeting = meetingFileService.listMeeting();
            if (listMeeting.size() > 0) {
                if ("1".equals(listMeeting.get(0).getStatus())) {
                    return "1";
                }
            }
        }
        if ("3".equals(i)) {
            List<RetrenchFile> listRetrench = retrenchFileService.listRetrench();
            if (listRetrench.size() > 0) {
                if ("1".equals(listRetrench.get(0).getStatus())) {
                    return "1";
                }
            }
        }
        return "0";
    }

    private FileSystemResource getFileSystemResource(File file) {
        return new FileSystemResource(file);
    }

    @ApiOperation("基础分析是否运行")
    @GetMapping("/statusExtraction")
    public StatusRetrenchFile getStatusExtraction() {
        return statusExtraction;
    }

    @ApiOperation("会议分析是否运行")
    @GetMapping("/statusParser")
    public StatusBasicsFile getStatusParser() {
        return statusParser;
    }

    @ApiOperation("精简分析是否运行")
    @GetMapping("/statusFile")
    public StatusMeetingFile getStatusFile() {
        return statusFile;
    }

    @ApiOperation("修改文件夹位置,默认路径(/2019/2021)")
    @PostMapping("/pathUrl")
    public String updatePathUrl(String url) {
        PathUrl.pathUrl = url;
        return PathUrl.pathUrl;
    }
}