package com.tykj.forecast.controller;

import com.alibaba.fastjson.JSONObject;
import com.tykj.forecast.entity.BasicsFile;
import com.tykj.forecast.entity.MeetingFile;
import com.tykj.forecast.entityVo.Statistics;
import com.tykj.forecast.service.IBasicsFileService;
import com.tykj.forecast.service.IMeetingFileService;
import com.tykj.forecast.utils.FileUtils;
import com.tykj.forecast.utils.PathUrl;
import com.tykj.forecast.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import static com.tykj.forecast.utils.CalculationUtils.format;

/**
 * @author mruny
 */
@RestController
@CrossOrigin
@RequestMapping("/meetingFiles")
@Api(tags = "会议文件")
@Slf4j
public class MeetingFileController {
    @Autowired
    private IBasicsFileService basicsFileService;
    @Autowired
    private IMeetingFileService meetingFileService;


//    /**
//     * 存入会议公文分析数据
//     *
//     * @return 存入的分析结果
//     */
//    @ApiOperation("批量存入会议公文分析数据")
//    @PostMapping
//    public ResponseEntity<List<MeetingFile>> insertMeetingFile(@RequestBody List<MeetingFile> meetingFileList) {
//        List<MeetingFile> list = new ArrayList<>();
//        for (MeetingFile meetingFile : meetingFileList) {
//            meetingFile.setStatus("1");
//            list.add(meetingFile);
//        }
//        List<MeetingFile> result = meetingFileService.saveAll(list);
//        return ResponseEntity.ok(result);
//    }

    /**
     * 分页查询会议公文分析数据
     *
     * @param pageSize 当前页数
     * @param pageNum  每页多少条数据
     * @return 查询到的结果
     */
    @ApiOperation("会议公文分析数据")
    @GetMapping
    public ResponseEntity<Page<MeetingFile>> pageMeetingFile(int pageSize, int pageNum, String status) {
        Page<MeetingFile> results = meetingFileService.findByStatus(pageNum - 1, pageSize, status);
        return ResponseEntity.ok(results);
    }

    /**
     * 清空会议公文分析数据
     */
    @ApiOperation("清空会议公文分析数据")
    @PutMapping
    public ResponseEntity<List<MeetingFile>> removeRetrenchFile() {
        List<MeetingFile> meetingFileList = meetingFileService.listMeeting();
        List<MeetingFile> list = new ArrayList<>();
        for (MeetingFile meetingFile : meetingFileList) {
            meetingFile.setStatus("0");
            list.add(meetingFile);
        }
        List<MeetingFile> results = meetingFileService.saveAll(list);
        return ResponseEntity.ok(results);
    }

    /**
     * 会议公文统计
     */
    @ApiOperation("会议公文统计")
    @GetMapping("/statistics")
    public Map<String, List<Statistics>> meetingStatistics() {
        Map<String, List<Statistics>> map = new HashMap<>();
        List<MeetingFile> listMeeting = meetingFileService.listMeeting();
        //成功文件数
        long count = meetingFileService.count();

        /*
         * 文件总数
         */
        List<Statistics> listSize = new ArrayList<>();
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        int fileSize = files.size();
        Statistics statisticsSize = new Statistics();
        statisticsSize.setValue(String.valueOf(fileSize));
        statisticsSize.setName("size");
        listSize.add(statisticsSize);
        map.put("size", listSize);
        /*
         * 成功文件数
         */
        List<Statistics> listSuccessSize = new ArrayList<>();
        Statistics statisticsSuccessSize = new Statistics();
        statisticsSuccessSize.setValue(String.valueOf(count));
        statisticsSuccessSize.setName("successSize");
        listSuccessSize.add(statisticsSuccessSize);
        map.put("successSize", listSuccessSize);
        /*
         * 会议分类统计
         */
        List<Statistics> listType = new ArrayList<>();
        //具体会议类型
        if (listMeeting.size() > 0) {
            Map<String, List<MeetingFile>> mapType = listMeeting.stream()
                    .filter(meetingFile -> meetingFile != null && !"".equals(meetingFile.getMeetingType()) && meetingFile.getMeetingType() != null)
                    .collect(Collectors.groupingBy(MeetingFile::getMeetingType));
            Set<String> types = new HashSet<>();
            if (mapType.size() > 0) {
                types = mapType.keySet();
            }
            //一类会议
            Statistics statisticsTypeOne = new Statistics("0", "一类会议");
            //二类会议
            Statistics statisticsTypeTwo = new Statistics("0", "二类会议");
            //三类会议
            Statistics statisticsTypeThree = new Statistics("0", "三类会议");
            for (String type : types) {
                long size = mapType.get(type).size();
                if ("1".equals(type)) {
                    statisticsTypeOne.setValue(String.valueOf(size));
                    statisticsTypeOne.setName("一类会议");
                }
                if ("2".equals(type)) {
                    statisticsTypeTwo.setValue(String.valueOf(size));
                    statisticsTypeTwo.setName("二类会议");
                }
                if ("3".equals(type)) {
                    statisticsTypeThree.setValue(String.valueOf(size));
                    statisticsTypeThree.setName("三类会议");
                }
            }
            listType.add(statisticsTypeOne);
            listType.add(statisticsTypeTwo);
            listType.add(statisticsTypeThree);
        }
        map.put("meetingType", listType);
        /*
         * 根据会议类型统计发文单位
         */
        //会议的类型   type会议类型 一类，二类...
        if (listMeeting.size() > 0) {
            Map<String, List<MeetingFile>> mapType = listMeeting.stream()
                    .filter(meetingFile -> !"".equals(meetingFile.getMeetingType()) && meetingFile.getMeetingType() != null)
                    .collect(Collectors.groupingBy(MeetingFile::getMeetingType));
            if (mapType.size() > 0) {
                Set<String> types = mapType.keySet();
                for (String type : types) {
                    List<Statistics> listIssueUnit = new ArrayList<>();
                    //第一类会议的所有东西
                    List<BasicsFile> basicsFileList = new ArrayList<>();
                    //第一中会议类型包括的所有单位
                    List<MeetingFile> meetingFileList = meetingFileService.findByMeetingType(type);
                    for (MeetingFile meetingFile : meetingFileList) {
                        //取出每个文件的名字
                        String customName = meetingFile.getCustomName();
                        BasicsFile basicsFiles = basicsFileService.findByCustomName(customName);
                        if (basicsFiles != null && basicsFiles.getCustomName() != null && !"".equals(basicsFiles.getCustomName())) {
                            basicsFileList.add(basicsFiles);
                        }
                    }
                    if (basicsFileList.size() > 0) {
                        Map<String, List<BasicsFile>> mapIssueUnit = basicsFileList.stream()
                                .filter(basicsFile -> basicsFile != null && basicsFile.getIssueUnit() != null && !"".equals(basicsFile.getIssueUnit()))
                                .collect(Collectors.groupingBy(BasicsFile::getIssueUnit));

                        if (mapIssueUnit.size() > 0) {
                            Set<String> issueUnits = mapIssueUnit.keySet();
                            for (String issueUnit : issueUnits) {
                                long size = mapIssueUnit.get(issueUnit).size();
                                Statistics statisticsIssueUnit = new Statistics();
                                statisticsIssueUnit.setValue(String.valueOf(size));
                                statisticsIssueUnit.setName(issueUnit);
                                listIssueUnit.add(statisticsIssueUnit);
                            }
                        }
                    }
                    if ("1".equals(type)) {
                        type = "meetingOne";
                    }
                    if ("2".equals(type)) {
                        type = "meetingTwo";
                    }
                    if ("3".equals(type)) {
                        type = "meetingThree";
                    }
                    if ("-1".equals(type)) {
                        type = "meetingOther";
                    }
                    map.put(type, listIssueUnit);
                }
            }
        }
        if (map.get("meetingOne") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("meetingOne", statisticsList);
        }
        if (map.get("meetingTwo") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("meetingTwo", statisticsList);
        }
        if (map.get("meetingThree") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("meetingThree", statisticsList);
        }
        if (map.get("meetingOther") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("meetingOther", statisticsList);
        }

        /*
         * 会议关键字内容百分比
         */
        List<Statistics> listKeyword = new ArrayList<>();
        //2.公文类别
        long sizeMeetingType = 0;
        if (listMeeting.size() > 0) {
            List<MeetingFile> collectMeetingType = listMeeting.stream()
                    .filter(meetingFile -> meetingFile != null && !"".equals(meetingFile.getMeetingType()) && meetingFile.getMeetingType() != null)
                    .collect(Collectors.toList());
            sizeMeetingType = collectMeetingType.size();
        }
        Statistics statisticsMeetingType = new Statistics();
        statisticsMeetingType.setName("公文类别");
        String numberMeetingType = format(sizeMeetingType, count);
        statisticsMeetingType.setValue(numberMeetingType);
        listKeyword.add(statisticsMeetingType);

        //3.发文字号
        List<BasicsFile> listIssueNumber = new ArrayList<>();
        long sizeIssueNumber = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getIssueNumber() != null && !"".equals(basicsFile.getIssueNumber())) {
                    listIssueNumber.add(basicsFile);
                }
            }
            sizeIssueNumber = listIssueNumber.size();
        }
        Statistics statisticsIssueNumber = new Statistics();
        statisticsIssueNumber.setName("发文字号");
        String numberIssueNumber = format(sizeIssueNumber, count);
        statisticsIssueNumber.setValue(numberIssueNumber);
        listKeyword.add(statisticsIssueNumber);
        //4.签发人
        List<BasicsFile> listIssuePerson = new ArrayList<>();
        long sizeIssuePerson = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getIssuePerson() != null && !"".equals(basicsFile.getIssuePerson())) {
                    listIssuePerson.add(basicsFile);
                }
            }
            sizeIssuePerson = listIssuePerson.size();
        }
        Statistics statisticsIssuePerson = new Statistics();
        statisticsIssuePerson.setName("签发人");
        String numberIssuePerson = format(sizeIssuePerson, count);
        statisticsIssuePerson.setValue(numberIssuePerson);
        listKeyword.add(statisticsIssuePerson);
        //5.标题
        List<BasicsFile> listTitle = new ArrayList<>();
        long sizeTitle = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getTitle() != null && !"".equals(basicsFile.getTitle())) {
                    listTitle.add(basicsFile);
                }
            }
            sizeTitle = listTitle.size();
        }
        Statistics statisticsTitle = new Statistics();
        statisticsTitle.setName("标题");
        String numberTitle = format(sizeTitle, count);
        statisticsTitle.setValue(numberTitle);
        listKeyword.add(statisticsTitle);
        //6.发文单位
        List<BasicsFile> listIssueUnit = new ArrayList<>();
        long sizeIssueUnit = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getIssueUnit() != null && !"".equals(basicsFile.getIssueUnit())) {
                    listIssueUnit.add(basicsFile);
                }
            }
            sizeIssueUnit = listIssueUnit.size();
        }
        Statistics statisticsIssueUnit = new Statistics();
        statisticsIssueUnit.setName("发文单位");
        String numberIssueUnit = format(sizeIssueUnit, count);
        statisticsIssueUnit.setValue(numberIssueUnit);
        listKeyword.add(statisticsIssueUnit);
        //7.接收单位
        List<BasicsFile> listAcceptUnit = new ArrayList<>();
        long sizeAcceptUnit = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getAcceptUnit() != null && !"".equals(basicsFile.getAcceptUnit())) {
                    listAcceptUnit.add(basicsFile);
                }
            }
            sizeAcceptUnit = listAcceptUnit.size();
        }
        Statistics statisticsAcceptUnit = new Statistics();
        statisticsAcceptUnit.setName("接收单位");
        String numberAcceptUnit = format(sizeAcceptUnit, count);
        statisticsAcceptUnit.setValue(numberAcceptUnit);
        listKeyword.add(statisticsAcceptUnit);
        //8.发文日期
        List<BasicsFile> listIssueDate = new ArrayList<>();
        long sizeIssueDate = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getIssueDate() != null && !"".equals(basicsFile.getIssueDate())) {
                    listIssueDate.add(basicsFile);
                }
            }
            sizeIssueDate = listIssueDate.size();
        }
        Statistics statisticsIssueDate = new Statistics();
        statisticsIssueDate.setName("发文日期");
        String numberIssueDate = format(sizeIssueDate, count);
        statisticsIssueDate.setValue(numberIssueDate);
        listKeyword.add(statisticsIssueDate);
        //9.抄送单位
        List<BasicsFile> listCopyUnit = new ArrayList<>();
        long sizeCopyUnit = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getCopyUnit() != null && !"".equals(basicsFile.getCopyUnit())) {
                    listCopyUnit.add(basicsFile);
                }
            }
            sizeCopyUnit = listCopyUnit.size();
        }
        Statistics statisticsCopyUnit = new Statistics();
        statisticsCopyUnit.setName("抄送单位");
        String numberCopyUnit = format(sizeCopyUnit, count);
        statisticsCopyUnit.setValue(numberCopyUnit);
        listKeyword.add(statisticsCopyUnit);
        //10.印发单位
        List<BasicsFile> listReplicaUnit = new ArrayList<>();
        long sizeReplicaUnit = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getReplicaUnit() != null && !"".equals(basicsFile.getReplicaUnit())) {
                    listReplicaUnit.add(basicsFile);
                }
            }
            sizeReplicaUnit = listReplicaUnit.size();
        }
        Statistics statisticsReplicaUnit = new Statistics();
        statisticsReplicaUnit.setName("印发单位");
        String numberReplicaUnit = format(sizeReplicaUnit, count);
        statisticsReplicaUnit.setValue(numberReplicaUnit);
        listKeyword.add(statisticsReplicaUnit);
        //11.印发日期
        List<BasicsFile> listReplicaDate = new ArrayList<>();
        long sizeReplicaDate = 0;
        if (listMeeting.size() > 0) {
            for (MeetingFile meetingFile : listMeeting) {
                String customName = meetingFile.getCustomName();
                BasicsFile basicsFile = basicsFileService.findByCustomName(customName);
                if (basicsFile != null && basicsFile.getReplicaDate() != null && !"".equals(basicsFile.getReplicaDate())) {
                    listReplicaDate.add(basicsFile);
                }
            }
            sizeReplicaDate = listReplicaDate.size();
        }
        Statistics statisticsReplicaDate = new Statistics();
        statisticsReplicaDate.setName("印发日期");
        String numberReplicaDate = format(sizeReplicaDate, count);
        statisticsReplicaDate.setValue(numberReplicaDate);
        listKeyword.add(statisticsReplicaDate);
        //12.参会人员
        long sizePants = 0;
        if (listMeeting.size() > 0) {
            List<MeetingFile> collectPants = listMeeting.stream()
                    .filter(meetingFile -> meetingFile != null && !"".equals(meetingFile.getParticiPants()) && meetingFile.getParticiPants() != null)
                    .collect(Collectors.toList());
            sizePants = collectPants.size();
        }
        Statistics statisticsPants = new Statistics();
        statisticsPants.setName("参会人员");
        String numberPants = format(sizePants, count);
        statisticsPants.setValue(numberPants);
        listKeyword.add(statisticsPants);
        //13.会议时间noMeetingInfo
        long sizeNoMeetingInfo = 0;
        if (listMeeting.size() > 0) {
            List<MeetingFile> collectNoMeetingInfo = listMeeting.stream()
                    .filter(meetingFile -> meetingFile != null && !"".equals(meetingFile.getNoMeetingInfo()) && meetingFile.getNoMeetingInfo() != null)
                    .collect(Collectors.toList());
            List<MeetingFile> meetingFileList = new ArrayList<>();
            for (MeetingFile meetingFile : collectNoMeetingInfo) {
                String noMeetingInfo = meetingFile.getNoMeetingInfo();
                if (noMeetingInfo != null && !"".equals(noMeetingInfo)) {
                    JSONObject jsonObject = JSONObject.parseObject(noMeetingInfo);
                    if (jsonObject.getJSONObject("noMeetingInfo") != null) {
                        String meetingTime = jsonObject.getJSONObject("noMeetingInfo").get("meetingTime").toString();
                        if (meetingTime != null && !"".equals(meetingTime)) {
                            meetingFileList.add(meetingFile);
                        }
                    }
                }
            }
            sizeNoMeetingInfo = meetingFileList.size();
        }
        Statistics statisticsNoMeetingInfo = new Statistics();
        statisticsNoMeetingInfo.setName("会议时间");
        String numberNoMeetingInfo = format(sizeNoMeetingInfo, count);
        statisticsNoMeetingInfo.setValue(numberNoMeetingInfo);
        listKeyword.add(statisticsNoMeetingInfo);
        map.put("KeywordStatistics", listKeyword);
        /*
         * 会议时间统计(月份)
         */
        //<文件名，类型>会议
        LocalDateTime now = LocalDateTime.now();
        //今年年份
        String nowYear = String.valueOf(now.getYear() - 1);
        List<MeetingFile> meetingFiles = new ArrayList<>();
        if (listMeeting.size() > 0) {
            meetingFiles = listMeeting.stream()
                    .filter(meetingFile -> meetingFile != null && meetingFile.getNoMeetingInfo() != null && !"".equals(meetingFile.getNoMeetingInfo()))
                    .collect(Collectors.toList());
        }
        //今年的文件
        List<MeetingFile> nowFile = new ArrayList<>();
        if (meetingFiles.size() > 0) {
            for (MeetingFile meetingFile : meetingFiles) {
                String noMeetingInfo = meetingFile.getNoMeetingInfo();
                if (noMeetingInfo != null && !"".equals(noMeetingInfo)) {
                    JSONObject jsonObject = JSONObject.parseObject(noMeetingInfo);
                    if (jsonObject != null && jsonObject.get("meetingTime") != null) {
                        String meetingTime = jsonObject.get("meetingTime").toString();
                        String year = StringUtil.substring(meetingTime);
                        if (nowYear.equals(year)) {
                            nowFile.add(meetingFile);
                        }
                    }
                }
            }
        }
        List<Statistics> statisticsArrayList = new ArrayList<>();
        //遍历12个月
        for (int i = 1; i < 13; i++) {
            //当前月的所有文件
            List<String> months = new ArrayList<>();
            //遍历所有当前年的文件
            if (nowFile.size() > 0) {
                for (MeetingFile meetingFile : nowFile) {
                    String noMeetingInfo = meetingFile.getNoMeetingInfo();
                    //将年月日转换为几月
                    if (noMeetingInfo != null && !"".equals(noMeetingInfo)) {
                        JSONObject jsonObject = JSONObject.parseObject(noMeetingInfo);
                        if (jsonObject != null && jsonObject.get("meetingTime") != null) {
                            String meetingTime = jsonObject.get("meetingTime").toString();
                            String monthDay = meetingTime.replace(nowYear + "-", "");
                            String month = StringUtil.substring(monthDay);
                            //判断当前文件是否属于当前月份
                            if (i < 10) {
                                if (month.equals("0" + i)) {
                                    months.add(month);
                                }
                            } else {
                                if (month.equals(i + "")) {
                                    months.add(month);
                                }
                            }
                        }
                    }
                }
            }
            Statistics statistics = new Statistics();
            statistics.setName(i + "月");
            statistics.setValue("0");
            if (months.size() > 0) {
                int size = months.size();
                statistics.setValue(String.valueOf(size));
            }
            statisticsArrayList.add(statistics);
        }
        map.put("issueData", statisticsArrayList);
        return map;
    }
}
