package com.tykj.forecast.controller;

import com.tykj.forecast.entity.BasicsFile;
import com.tykj.forecast.entity.RetrenchFile;
import com.tykj.forecast.entityVo.Statistics;
import com.tykj.forecast.service.IBasicsFileService;
import com.tykj.forecast.service.IRetrenchFileService;
import com.tykj.forecast.utils.FileUtils;
import com.tykj.forecast.utils.PathUrl;
import com.tykj.forecast.utils.StringUtil;
import com.tykj.forecast.vo.FileTestVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import static com.tykj.forecast.utils.CalculationUtils.format;

/**
 * @author mruny
 */
@RestController
@CrossOrigin
@RequestMapping("/retrenchFiles")
@Api(tags = "重要精简")
public class RetrenchFileController {
    @Autowired
    private IBasicsFileService basicsFileService;
    @Autowired
    private IRetrenchFileService retrenchFileService;

//    /**
//     * 存入重点精简文件分析数据
//     *
//     * @return 存入的分析结果
//     */
//    @ApiOperation("批量存入重点精简文件分析数据")
//    @PostMapping
//    public ResponseEntity<List<RetrenchFile>> insertRetrenchFile(@RequestBody List<RetrenchFile> retrenchFileList) {
//        List<RetrenchFile> list = new ArrayList<>();
//        for (RetrenchFile retrenchFile : retrenchFileList) {
//            retrenchFile.setStatus("1");
//            list.add(retrenchFile);
//        }
//        List<RetrenchFile> results = retrenchFileService.saveAll(list);
//        return ResponseEntity.ok(results);
//    }

    /**
     * 分页查询重点精简文件分析数据
     *
     * @param pageSize 当前页数
     * @param pageNum  每页多少条数据
     * @return 查询到的结果
     */
    @ApiOperation("重点精简文件分析数据")
    @GetMapping
    public ResponseEntity<Page<RetrenchFile>> pageRetrenchFile(int pageSize, int pageNum, String status) {
        Page<RetrenchFile> results = retrenchFileService.findByStatus(pageNum - 1, pageSize, status);
        return ResponseEntity.ok(results);
    }

    /**
     * 清空精简文件分析数据
     */
    @ApiOperation("清空精简文件分析数据")
    @PutMapping
    public ResponseEntity<List<RetrenchFile>> removeRetrenchFile() {
        List<RetrenchFile> retrenchFiles = retrenchFileService.listRetrench();
        List<RetrenchFile> list = new ArrayList<>();
        for (RetrenchFile retrenchFile : retrenchFiles) {
            retrenchFile.setStatus("0");
            list.add(retrenchFile);
        }
        List<RetrenchFile> results = retrenchFileService.saveAll(list);
        return ResponseEntity.ok(results);
    }

    /**
     * 重点精简文件统计
     */
    @ApiOperation("重点精简文件统计")
    @GetMapping("/statistics")
    public Map<String, List<Statistics>> retrenchStatistics() {
        Map<String, List<Statistics>> map = new HashMap<>();
        List<BasicsFile> basicsFiles = basicsFileService.listBasics();
        List<RetrenchFile> listRetrench = retrenchFileService.listRetrench();
        /*
         * 关键内容频次统计
         */
        //总数据
        Long count = retrenchFileService.count();
        List<Statistics> listKeyword = new ArrayList<>();
        //公文类别
        long sizeFileType = 0;
        if (listRetrench.size() > 0) {
            List<RetrenchFile> collectFileType = listRetrench.stream()
                    .filter(basicsFile -> basicsFile != null && !"".equals(basicsFile.getFileType()) && basicsFile.getFileType() != null)
                    .collect(Collectors.toList());
            sizeFileType = collectFileType.size();
        }
        Statistics statisticsFileType = new Statistics();
        statisticsFileType.setName("公文类别");
        String numberFileType = format(sizeFileType, count);
        statisticsFileType.setValue(numberFileType);
        listKeyword.add(statisticsFileType);
        //发文字号issuedNumber
        List<RetrenchFile> collectIssueNumber = new ArrayList<>();
        long sizeIssuedNumber = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getIssueNumber() != null && !"".equals(byCustomName.getIssueNumber())) {
                    collectIssueNumber.add(retrench);
                }
            }
            sizeIssuedNumber = collectIssueNumber.size();
        }
        Statistics statisticsIssuedNumber = new Statistics();
        statisticsIssuedNumber.setName("发文字号");
        String numberIssuedNumber = format(sizeIssuedNumber, count);
        statisticsIssuedNumber.setValue(numberIssuedNumber);
        listKeyword.add(statisticsIssuedNumber);

        //签发人issuer
        List<RetrenchFile> collectIssuePerson = new ArrayList<>();
        long sizeIssuer = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getIssuePerson() != null && !"".equals(byCustomName.getIssuePerson())) {
                    collectIssuePerson.add(retrench);
                }
            }
            sizeIssuer = collectIssuePerson.size();
        }
        Statistics statisticsIssuer = new Statistics();
        statisticsIssuer.setName("签发人");
        String numberIssuer = format(sizeIssuer, count);
        statisticsIssuer.setValue(numberIssuer);
        listKeyword.add(statisticsIssuer);

        //标题
        long sizeTitle = 0;
        if (listRetrench.size() > 0) {
            List<RetrenchFile> collectTitle = listRetrench.stream()
                    .filter(tittle -> tittle != null && tittle.getTitle() != null && !"".equals(tittle.getTitle()))
                    .collect(Collectors.toList());
            sizeTitle = collectTitle.size();
        }
        Statistics statisticsTitle = new Statistics();
        statisticsTitle.setName("标题");
        String numberTitle = format(sizeTitle, count);
        statisticsTitle.setValue(numberTitle);
        listKeyword.add(statisticsTitle);

        //发文单位
        List<RetrenchFile> collectIssueUnit = new ArrayList<>();
        long sizeMainUnit = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getIssueUnit() != null && !"".equals(byCustomName.getIssueUnit())) {
                    collectIssueUnit.add(retrench);
                }
            }
            sizeMainUnit = collectIssueUnit.size();
        }
        Statistics statisticsMainUnit = new Statistics();
        statisticsMainUnit.setName("发文单位");
        String numberMainUnit = format(sizeMainUnit, count);
        statisticsMainUnit.setValue(numberMainUnit);
        listKeyword.add(statisticsMainUnit);

        //接收单位receiveUnit
        List<RetrenchFile> collectAcceptUnit = new ArrayList<>();
        long sizeReceiveUnit = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getReplicaUnit() != null && !"".equals(byCustomName.getReplicaUnit())) {
                    collectAcceptUnit.add(retrench);
                }
            }
            sizeReceiveUnit = collectAcceptUnit.size();
        }
        Statistics statisticsReceiveUnit = new Statistics();
        statisticsReceiveUnit.setName("接收单位");
        String numberReceiveUnit = format(sizeReceiveUnit, count);
        statisticsReceiveUnit.setValue(numberReceiveUnit);
        listKeyword.add(statisticsReceiveUnit);

        //发文日期
        List<RetrenchFile> collectIssueDate = new ArrayList<>();
        long sizeIssueDate = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getIssueDate() != null && !"".equals(byCustomName.getIssueDate())) {
                    collectIssueDate.add(retrench);
                }
            }
            sizeIssueDate = collectIssueDate.size();
        }
        Statistics statisticsIssueDate = new Statistics();
        statisticsIssueDate.setName("发文日期");
        String numberIssueDate = format(sizeIssueDate, count);
        statisticsIssueDate.setValue(numberIssueDate);
        listKeyword.add(statisticsIssueDate);

        //抄送单位copyUnit
        List<RetrenchFile> collectCopyUnit = new ArrayList<>();
        long sizeCopyUnit = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getCopyUnit() != null && !"".equals(byCustomName.getCopyUnit())) {
                    collectCopyUnit.add(retrench);
                }
            }
            sizeCopyUnit = collectCopyUnit.size();
        }
        Statistics statisticsCopyUnit = new Statistics();
        statisticsCopyUnit.setName("抄送单位");
        String numberCopyUnit = format(sizeCopyUnit, count);
        statisticsCopyUnit.setValue(numberCopyUnit);
        listKeyword.add(statisticsCopyUnit);

        //印发单位replicaUnit
        List<RetrenchFile> collectReplicaUnit = new ArrayList<>();
        long sizeReplicaUnit = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getReplicaUnit() != null && !"".equals(byCustomName.getReplicaUnit())) {
                    collectReplicaUnit.add(retrench);
                }
            }
            sizeReplicaUnit = collectReplicaUnit.size();
        }
        Statistics statisticsReplicaUnit = new Statistics();
        statisticsReplicaUnit.setName("印发单位");
        String numberReplicaUnit = format(sizeReplicaUnit, count);
        statisticsReplicaUnit.setValue(numberReplicaUnit);
        listKeyword.add(statisticsReplicaUnit);

        //印发日期replicaDate
        List<RetrenchFile> collectReplicaDate = new ArrayList<>();
        long sizeReplicaDate = 0;
        if (listRetrench.size() > 0) {
            for (RetrenchFile retrench : listRetrench) {
                String customName = retrench.getCustomName();
                BasicsFile byCustomName = basicsFileService.findByCustomName(customName);
                if (byCustomName != null && byCustomName.getReplicaDate() != null && !"".equals(byCustomName.getReplicaDate())) {
                    collectReplicaDate.add(retrench);
                }
            }
            sizeReplicaDate = collectReplicaDate.size();
        }
        Statistics statisticsReplicaDate = new Statistics();
        statisticsReplicaDate.setName("印发时间");
        String numberReplicaDate = format(sizeReplicaDate, count);
        statisticsReplicaDate.setValue(numberReplicaDate);
        listKeyword.add(statisticsReplicaDate);
        map.put("KeywordStatistics", listKeyword);

        /*
         * 文件总数
         */
        List<Statistics> listSize = new ArrayList<>();
        List<File> files = FileUtils.getFiles(PathUrl.pathUrl);
        int fileSize = files.size();
        Statistics statisticsSize = new Statistics();
        statisticsSize.setValue(String.valueOf(fileSize));
        statisticsSize.setName("size");
        listSize.add(statisticsSize);
        map.put("size", listSize);
        /*
         * 成功文件数
         */
        List<Statistics> listSuccessSize = new ArrayList<>();
        Statistics statisticsSuccessSize = new Statistics();
        statisticsSuccessSize.setValue(String.valueOf(count));
        statisticsSuccessSize.setName("successSize");
        listSuccessSize.add(statisticsSuccessSize);
        map.put("successSize", listSuccessSize);
        /*
         * 文件分类
         */
        List<Statistics> listType = new ArrayList<>();
        Statistics statisticsTypeStandard = new Statistics("0", "规范性文件");
        Statistics statisticsTypeNotification = new Statistics("0", "通报类文件");
        Statistics statisticsTypeDeliberation = new Statistics("0", "议事协调机构类文件");
        Map<String, List<RetrenchFile>> mapType = new HashMap<>();
        Set<String> types = new HashSet<>();
        if (listRetrench.size() > 0) {
            mapType = listRetrench.stream()
                    .filter(retrenchFile -> retrenchFile != null && !"".equals(retrenchFile.getFileType()) && retrenchFile.getFileType() != null)
                    .collect(Collectors.groupingBy(RetrenchFile::getFileType));
            types = mapType.keySet();
        }
        if (types.size() > 0) {
            for (String type : types) {
                long size = mapType.get(type).size();
                if ("0".equals(type)) {
                    statisticsTypeStandard.setValue(String.valueOf(size));
                    statisticsTypeStandard.setName("规范性文件");
                }
                if ("1".equals(type)) {
                    statisticsTypeNotification.setValue(String.valueOf(size));
                    statisticsTypeNotification.setName("通报类文件");
                }
                if ("2".equals(type)) {
                    statisticsTypeDeliberation.setValue(String.valueOf(size));
                    statisticsTypeDeliberation.setName("议事协调机构类文件");
                }
            }
        }
        listType.add(statisticsTypeStandard);
        listType.add(statisticsTypeNotification);
        listType.add(statisticsTypeDeliberation);
        map.put("fileType", listType);

        //<文件名，类型>
        Map<String, String> mapFileType = new HashMap<>();
        if (listRetrench.size() > 0) {
            mapFileType = listRetrench.stream().collect(Collectors.toMap(RetrenchFile::getCustomName, RetrenchFile::getFileType));
        }
        Map<String, String> finalMapFileType = mapFileType;
        List<FileTestVo> collectNameType = basicsFiles.stream().map(basicsFile -> {
            FileTestVo fileTestVo = new FileTestVo();
            BeanUtils.copyProperties(basicsFile, fileTestVo);
            String s = finalMapFileType.get(fileTestVo.getCustomName());
            if (!"".equals(s) && s != null) {
                fileTestVo.setFileType(s);
                finalMapFileType.remove(fileTestVo.getCustomName());
            }
            return fileTestVo;
        }).collect(Collectors.toList());

        /*
         * 类别，发文月份统计数量
         * 每个月按照不同类别，统计
         */
        LocalDateTime now = LocalDateTime.now();
        //今年年份
        String nowYear = String.valueOf(now.getYear() - 1);
        List<FileTestVo> nowFile = new ArrayList<>();
        for (FileTestVo fileTestVo : collectNameType) {
            if (fileTestVo != null && fileTestVo.getIssueDate() != null && !"".equals(fileTestVo.getIssueDate())) {
                String date = fileTestVo.getIssueDate();
                String year = StringUtil.substring(date);
                if (nowYear.equals(year)) {
                    nowFile.add(fileTestVo);
                }
            }
        }
        //今年的文件 key 类型  value 文件
        Map<String, List<FileTestVo>> collectType = nowFile.stream()
                .filter(fileTestVo -> fileTestVo.getFileType() != null && !"".equals(fileTestVo.getFileType()))
                .collect(Collectors.groupingBy(FileTestVo::getFileType));
        //文件类型
        Set<String> typeList = collectType.keySet();
        for (String type : typeList) {
            List<Statistics> statisticsList = new ArrayList<>();
            List<FileTestVo> fileTestVoList = collectType.get(type);
            for (int i = 1; i < 13; i++) {
                List<FileTestVo> fileType = new ArrayList<>();
                for (FileTestVo fileTestVo : fileTestVoList) {
                    if (fileTestVo != null && fileTestVo.getIssueDate() != null && !"".equals(fileTestVo.getIssueDate())) {
                        String date = fileTestVo.getIssueDate();
                        String monthDay = date.replace(nowYear + "-", "");
                        String month = StringUtil.substring(monthDay);
                        if (i < 10) {
                            if (month.equals("0" + i)) {
                                fileType.add(fileTestVo);
                            }
                        } else {
                            if (month.equals(i + "")) {
                                fileType.add(fileTestVo);
                            }
                        }

                    }
                }
                Statistics statistics = new Statistics();
                statistics.setName(i + "月");
                statistics.setValue(String.valueOf(fileType.size()));
                statisticsList.add(statistics);
            }
            map.put("month" + type, statisticsList);
        }
        if (map.get("month0") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            for (int i = 1; i < 13; i++) {
                Statistics statistics = new Statistics();
                statistics.setValue("0");
                statistics.setName(i + "月");
                statisticsList.add(statistics);
            }
            map.put("month0", statisticsList);
        }
        if (map.get("month1") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            for (int i = 1; i < 13; i++) {
                Statistics statistics = new Statistics();
                statistics.setValue("0");
                statistics.setName(i + "月");
                statisticsList.add(statistics);
            }
            map.put("month1", statisticsList);
        }
        if (map.get("month2") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            for (int i = 1; i < 13; i++) {
                Statistics statistics = new Statistics();
                statistics.setValue("0");
                statistics.setName(i + "月");
                statisticsList.add(statistics);
            }
            map.put("month2", statisticsList);
        }

        /*
         * 发文统计单位
         */
        Map<String, List<FileTestVo>> collect = collectNameType.stream()
                .filter(fileTestVo -> fileTestVo.getFileType() != null && !"".equals(fileTestVo.getFileType()))
                .collect(Collectors.groupingBy(FileTestVo::getFileType));
        Set<String> typeSets = collect.keySet();
        //类型
        for (String typeSet : typeSets) {
            List<Statistics> statisticsList = new ArrayList<>();
            List<FileTestVo> fileTestVoList = collect.get(typeSet);
            //key单位 value文件
            Map<String, List<FileTestVo>> collectUnit = fileTestVoList.stream()
                    .filter(fileTestVo -> fileTestVo.getBodyIssuingUnit() != null && !"".equals(fileTestVo.getBodyIssuingUnit()))
                    .collect(Collectors.groupingBy(FileTestVo::getBodyIssuingUnit));
            //单位
            Set<String> units = collectUnit.keySet();
            for (String unit : units) {
                Statistics statistics = new Statistics();
                statistics.setName(unit);
                statistics.setValue(String.valueOf(collectUnit.get(unit).size()));
                statisticsList.add(statistics);
            }
            map.put("unit" + typeSet, statisticsList);
        }
        if (map.get("unit0") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("unit0", statisticsList);
        }
        if (map.get("unit1") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("unit1", statisticsList);
        }
        if (map.get("unit2") == null) {
            List<Statistics> statisticsList = new ArrayList<>();
            map.put("unit2", statisticsList);
        }
        return map;
    }

}
