package com.tykj.forecast.dao;

import com.tykj.forecast.entity.MeetingFile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
public interface MeetingFileDao extends JpaRepository<MeetingFile, Long>, JpaSpecificationExecutor<MeetingFile> {

    /**
     * 根据会议类型查询文件
     *
     * @param meetingType 文件类型
     * @return 查询到的文件集合
     */
    List<MeetingFile> findMeetingFileByMeetingType(String meetingType);

    /**
     * 分页查询所有文件
     *
     * @param status   是否存在,1为存在,0为不存在
     * @param pageable 分页
     * @return 分页后的文件
     */
    Page<MeetingFile> findByStatus(String status, Pageable pageable);

}
