package com.tykj.forecast.dao;

import com.tykj.forecast.entity.RetrenchFile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
public interface RetrenchFileDao extends JpaRepository<RetrenchFile, Long>, JpaSpecificationExecutor<RetrenchFile> {

    /**
     * 分页查询所有文件
     *
     * @param status   是否存在,1为存在,0为不存在
     * @param pageable 分页
     * @return 分页后的文件
     */
    Page<RetrenchFile> findByStatus(String status, Pageable pageable);
}
