package com.tykj.forecast.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * 公文基础识别
 *
 * @author mruny
 * @create 2022/6/14 10:52:29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("公文基础识别")
@Entity
@Table(name = "basics_file")
@EntityListeners(AuditingEntityListener.class)
public class BasicsFile {

    /**
     * 主键id
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id,从0开始自增")
    private Long id;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "数据创建时间")
    @Column(name = "create_time")
    @CreatedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "数据更新时间")
    @Column(name = "update_time")
    @LastModifiedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date updateTime;

    /**
     * 文件名称
     */
    @Column(name = "custom_name")
    @ApiModelProperty("文件名称")
    private String customName;


    /**
     * 文件类型
     */
    @Column(name = "association_category")
    @ApiModelProperty("文件类型")
    private String associationCategory;

    /**
     * 发文字号
     */
    @Column(name = "issue_number")
    @ApiModelProperty("发文字号")
    private String issueNumber;

    /**
     * 版头发文单位
     */
    @Column(name = "front_issuing_unit")
    @ApiModelProperty("版头发文单位")
    private String frontIssuingUnit;

    /**
     * 签发人
     */
    @Column(name = "issue_person")
    @ApiModelProperty("签发人")
    private String issuePerson;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty("标题")
    private String title;

    /**
     * 主体发文单位
     */
    @Column(name = "body_issuing_unit")
    @ApiModelProperty("主体发文单位")
    private String bodyIssuingUnit;

    /**
     * 接收单位
     */
    @Column(name = "accept_unit")
    @ApiModelProperty("接收单位")
    private String acceptUnit;

    /**
     * 发文日期
     */
    @Column(name = "issue_date")
    @ApiModelProperty("发文日期")
    private String issueDate;

    /**
     * 抄送单位
     */
    @Column(name = "copy_unit")
    @ApiModelProperty("抄送单位")
    private String copyUnit;

    /**
     * 发文单位
     */
    @Column(name = "issue_unit")
    @ApiModelProperty("发文单位")
    private String issueUnit;

    /**
     * 印发日期对应发文日期issueDate
     */
    @Column(name = "replica_date")
    @ApiModelProperty("印发日期对应发文日期issueDate")
    private String replicaDate;

    /**
     * 印发单位对应发文单位issueUnit
     */
    @Column(name = "replica_unit")
    @ApiModelProperty("印发单位对应发文单位issueUnit")
    private String replicaUnit;

    /**
     * 文件数量
     */
    @Column(name = "size")
    @ApiModelProperty("文件数量")
    private Long size;

    /**
     * 是否删除
     */
    @Column(name = "status")
    @ApiModelProperty("是否删除数据,0是不存在，1是存在")
    private String status;
}
