package com.tykj.forecast.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * 会议公文分析
 *
 * @author mruny
 * @create 2022/6/14 10:53:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "meeting_file")
@EntityListeners(AuditingEntityListener.class)
@ApiModel("会议公文分析")
public class MeetingFile {

    /**
     * 主键id
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id,从0开始自增")
    private Long id;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "数据创建时间")
    @Column(name = "create_time")
    @CreatedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "数据更新时间")
    @Column(name = "update_time")
    @LastModifiedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date updateTime;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty("标题")
    private String fileTitle;

    /**
     * 文件名称
     */
    @Column(name = "custom_name")
    @ApiModelProperty("文件名称")
    private String customName;

    /**
     * 会议类型
     */
    @Column(name = "meeting_type")
    @ApiModelProperty("会议类型")
    private String meetingType;

    /**
     * 参会人员
     */
    @Column(name = "partici_pants")
    @ApiModelProperty("参会人员")
    private String particiPants;

    /**
     * 包括会议时间
     */
    @Column(name = "no_meeting_info")
    @ApiModelProperty("包括会议时间")
    private String noMeetingInfo;

    /**
     * 文件数量
     */
    @Column(name = "size")
    @ApiModelProperty("文件数量")
    private Long size;

    /**
     * 是否删除
     */
    @Column(name = "status")
    @ApiModelProperty("是否删除数据,0是不存在，1是存在")
    private String status;
}
