package com.tykj.forecast.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * 重点精简文件
 *
 * @author mruny
 * @create 2022/6/14 10:54:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "retrench_file")
@EntityListeners(AuditingEntityListener.class)
@ApiModel("重点精简文件")
public class RetrenchFile {

    /**
     * 主键id
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id,从0开始自增")
    private Long id;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "数据创建时间")
    @Column(name = "create_time")
    @CreatedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "数据更新时间")
    @Column(name = "update_time")
    @LastModifiedDate
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private Date updateTime;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty("标题")
    private String title;

    /**
     * 文件类别{"规范性文件":0, "通报类文件":1, "议事协调机构类文件":2, "其他类":3}
     */
    @Column(name = "file_type")
    @ApiModelProperty("文件类别{规范性文件:0, 通报类文件:1, 议事协调机构类文件:2, 其他类:3}")
    private String fileType;

    /**
     * 文件名称
     */
    @Column(name = "custom_name")
    @ApiModelProperty("文件名称")
    private String customName;

    /**
     * 文件数量
     */
    @Column(name = "size")
    @ApiModelProperty("文件数量")
    private Long size;

    /**
     * 是否删除
     */
    @Column(name = "status")
    @ApiModelProperty("是否删除数据,0是不存在，1是存在")
    private String status;
}
