package com.tykj.forecast.service;

import com.tykj.forecast.entity.BasicsFile;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
public interface IBasicsFileService {

    /**
     * 添加或修改
     *
     * @param forecast 添加或修改的对象
     * @return 添加或修改后的对象
     */
    BasicsFile save(BasicsFile forecast);

    /**
     * 删除所有
     */
    void removeAll();

    /**
     * 查询所有
     *
     * @return 所有对象的集合
     */
    List<BasicsFile> listBasics();

    /**
     * 根据文件路径查询文件
     *
     * @param customName 文件路径
     * @return 查询到的文件
     */
    BasicsFile findByCustomName(String customName);

    /**
     * 存入数据数量
     *
     * @return 存入数据数量
     */
    Long count();

    /**
     * 批量新增/修改
     *
     * @param list 批量新增/修改的对象集合
     * @return 批量新增/修改后的对象集合
     */
    List<BasicsFile> saveAll(List<BasicsFile> list);

    /**
     * 分页条件查询
     *
     * @param page   当前第几页
     * @param size   每页多少条数据
     * @param status 查询条件
     * @return 符合条件的分页结果数据
     */
    Page<BasicsFile> findByStatus(int page, int size, String status);
}
