package com.tykj.forecast.service;

import com.tykj.forecast.entity.MeetingFile;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
public interface IMeetingFileService {

    /**
     * 新增/修改
     *
     * @param forecast 新增/修改对象
     * @return 新增/修改后的对象
     */
    MeetingFile save(MeetingFile forecast);

    /**
     * 删除所有数据
     */
    void removeAll();

    /**
     * 查询所有会议文件
     *
     * @return 查询到的所有会议文件
     */
    List<MeetingFile> listMeeting();

    /**
     * 根据文件类型查找会议文件
     *
     * @param meetingType 会议类型
     * @return 所有符合条件的会议文件
     */
    List<MeetingFile> findByMeetingType(String meetingType);

    /**
     * 存入文件的总数量
     *
     * @return 存入文件的总数量
     */
    long count();

    /**
     * 批量添加/修改
     *
     * @param list 批量添加/修改的对象集合
     * @return 批量添加/修改后的对象集合
     */
    List<MeetingFile> saveAll(List<MeetingFile> list);

    /**
     * 分页条件查询
     *
     * @param page   当前第几页
     * @param size   每页多少条数据
     * @param status 查询条件
     * @return 分页条件查询的结果
     */
    Page<MeetingFile> findByStatus(int page, int size, String status);

}
