package com.tykj.forecast.service;

import com.tykj.forecast.entity.RetrenchFile;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
public interface IRetrenchFileService {

    /**
     * 添加/修改精简文件
     *
     * @param forecast 精简文件对象
     * @return 添加/修改后的精简文件对象
     */
    RetrenchFile save(RetrenchFile forecast);

    /**
     * 删除所有数据
     */
    void removeAll();

    /**
     * 查询所有精简文件
     *
     * @return 所有精简文件对象集合
     */
    List<RetrenchFile> listRetrench();

    /**
     * 批量新增/修改精简文件
     *
     * @param list 精简文件集合
     * @return 批量新增/修改后的精简文件集合
     */
    List<RetrenchFile> saveAll(List<RetrenchFile> list);

    /**
     * 分页条件查询
     *
     * @param page   当前第几页
     * @param size   每页多少条数据
     * @param status 查询条件
     * @return 符合条件的分页查询结果
     */
    Page<RetrenchFile> findByStatus(int page, int size, String status);

    /**
     * 文件数量
     *
     * @return 文件数量
     */
    Long count();
}
