package com.tykj.forecast.service.Impl;

import com.tykj.forecast.config.GlobalException;
import com.tykj.forecast.dao.BasicsFileDao;
import com.tykj.forecast.entity.BasicsFile;
import com.tykj.forecast.service.IBasicsFileService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
@Service
public class BasicsFileServiceImpl implements IBasicsFileService {

    private final BasicsFileDao dao;

    public BasicsFileServiceImpl(BasicsFileDao dao) {
        this.dao = dao;
    }

    @Override
    public BasicsFile save(BasicsFile forecast) {
        return Optional.of(dao.save(forecast)).orElseThrow(() -> new GlobalException("添加失败"));
    }

    @Override
    public void removeAll() {
        dao.deleteAllInBatch();
    }

    @Override
    public List<BasicsFile> listBasics() {
        return dao.findAll();
    }

    @Override
    public BasicsFile findByCustomName(String customName) {
        return dao.findBasicsFileByCustomName(customName);
    }

    @Override
    public Long count() {
        return dao.count();
    }

    @Override
    public List<BasicsFile> saveAll(List<BasicsFile> list) {
        return dao.saveAll(list);
    }

    @Override
    public Page<BasicsFile> findByStatus(int page, int size, String status) {
        Pageable pageable = PageRequest.of(page, size);
        return dao.findByStatus(status, pageable);
    }

}
