package com.tykj.forecast.service.Impl;

import com.tykj.forecast.config.GlobalException;
import com.tykj.forecast.dao.MeetingFileDao;
import com.tykj.forecast.entity.MeetingFile;
import com.tykj.forecast.service.IMeetingFileService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
@Service
public class MeetingFileServiceImpl implements IMeetingFileService {
    private final MeetingFileDao dao;

    public MeetingFileServiceImpl(MeetingFileDao dao) {
        this.dao = dao;
    }

    @Override
    public MeetingFile save(MeetingFile forecast) {
        return Optional.of(dao.save(forecast)).orElseThrow(() -> new GlobalException("添加失败"));
    }

    @Override
    public void removeAll() {
        dao.deleteAllInBatch();
    }

    @Override
    public List<MeetingFile> listMeeting() {
        return dao.findAll();
    }

    @Override
    public List<MeetingFile> findByMeetingType(String meetingType) {
        return dao.findMeetingFileByMeetingType(meetingType);
    }

    @Override
    public long count() {
        return dao.count();
    }

    @Override
    public List<MeetingFile> saveAll(List<MeetingFile> list) {
        return dao.saveAll(list);
    }

    @Override
    public Page<MeetingFile> findByStatus(int page, int size, String status) {
        Pageable pageable = PageRequest.of(page, size);
        return dao.findByStatus(status, pageable);
    }
}
