package com.tykj.forecast.service.Impl;

import com.tykj.forecast.config.GlobalException;
import com.tykj.forecast.dao.RetrenchFileDao;
import com.tykj.forecast.entity.RetrenchFile;
import com.tykj.forecast.service.IRetrenchFileService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-06-14
 */
@Service
public class RetrenchFileServiceImpl implements IRetrenchFileService {
    private final RetrenchFileDao dao;

    public RetrenchFileServiceImpl(RetrenchFileDao dao) {
        this.dao = dao;
    }

    @Override
    public RetrenchFile save(RetrenchFile forecast) {
        return Optional.of(dao.save(forecast)).orElseThrow(() -> new GlobalException("添加失败"));
    }

    @Override
    public void removeAll() {
        dao.deleteAllInBatch();
    }

    @Override
    public List<RetrenchFile> listRetrench() {
        return dao.findAll();
    }

    @Override
    public List<RetrenchFile> saveAll(List<RetrenchFile> list) {
        return dao.saveAll(list);
    }

    @Override
    public Page<RetrenchFile> findByStatus(int page, int size, String status) {
        Pageable pageable = PageRequest.of(page, size);
        return dao.findByStatus(status, pageable);
    }

    @Override
    public Long count() {
        return dao.count();
    }
}
