package com.tykj.forecast.utils;

import com.tykj.forecast.config.GlobalException;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author mruny
 * @create 2022/6/13 11:21:27
 */
public class FileUtils {

    public static List<File> getFiles(String fileName) {
        List<File> listAll = new ArrayList<>();
        File dirFile = new File(fileName);
        //获取到文件夹下所有文件
        File[] files = dirFile.listFiles();
        try {
            if (files != null && files.length > 0) {
                List<File> list = new ArrayList<>(Arrays.asList(files));
                for (File file : list) {
                    String name = file.getName();
                    String lowerName = name.toLowerCase();
                    if (!name.contains(".")) {
                        List<File> fileChildren = getFiles(fileName + "/" + name);
                        listAll.addAll(fileChildren);
                    } else {
                        if (lowerName.matches("^.+\\.(doc|docx|wps)$")) {
                            listAll.add(file);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            //终止程序
            throw new GlobalException("文件夹不存在");
        }
        return listAll;
    }

}