package com.tykj.forecast.vo;

import com.tykj.forecast.entity.BasicsFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * 基础公文接收json
 *
 * @author mruny
 * @create 2022/6/13 14:56:47
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("公文基础识别json")
public class BasicsFileVo {

    /**
     * 文件名称
     */
    @ApiModelProperty("文件名称")
    private String customName;


    /**
     * 文件类型
     */
    @ApiModelProperty("文件类型")
    private String associationCategory;

    /**
     * 发文字号
     */
    @ApiModelProperty("发文字号")
    private String issueNumber;

    /**
     * 版头发文单位
     */
    @ApiModelProperty("版头发文单位")
    private String frontIssuingUnit;

    /**
     * 签发人
     */
    @ApiModelProperty("签发人")
    private String issuePerson;

    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 主体发文单位
     */
    @ApiModelProperty("主体发文单位")
    private String bodyIssuingUnit;

    /**
     * 接收单位
     */
    @ApiModelProperty("接收单位")
    private String acceptUnit;

    /**
     * 发文日期
     */
    @ApiModelProperty("发文日期")
    private String issueDate;

    /**
     * 抄送单位
     */
    @ApiModelProperty("抄送单位")
    private String copyUnit;

    /**
     * 发文单位
     */
    @ApiModelProperty("发文单位")
    private String issueUnit;

    /**
     * 印发日期对应发文日期issueDate
     */
    @ApiModelProperty("印发日期对应发文日期issueDate")
    private String replicaDate;

    /**
     * 印发单位对应发文单位issueUnit
     */
    @ApiModelProperty("印发单位对应发文单位issueUnit")
    private String replicaUnit;

    /**
     * 文件数量
     */
    @ApiModelProperty("文件数量")
    private int size;

    public BasicsFile toBasicsFile(){
        BasicsFile basicsFile = new BasicsFile();
        BeanUtils.copyProperties(this,basicsFile);
        return basicsFile;
    }
}
