package com.tykj.forecast.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;

/**
 * @author mruny
 * @create 2022/6/20 13:42:33
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FileBasicsMeetingVO {

    /**
     * 文件名称
     */
    @Column(name = "custom_name")
    @ApiModelProperty("文件名称")
    private String customName;


    /**
     * 文件类型
     */
    @Column(name = "association_category")
    @ApiModelProperty("文件类型")
    private String associationCategory;

    /**
     * 发文字号
     */
    @Column(name = "issue_number")
    @ApiModelProperty("发文字号")
    private String issueNumber;

    /**
     * 版头发文单位
     */
    @Column(name = "front_issuing_unit")
    @ApiModelProperty("版头发文单位")
    private String frontIssuingUnit;

    /**
     * 签发人
     */
    @Column(name = "issue_person")
    @ApiModelProperty("签发人")
    private String issuePerson;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty("标题")
    private String title;

    /**
     * 主体发文单位
     */
    @Column(name = "body_issuing_unit")
    @ApiModelProperty("主体发文单位")
    private String bodyIssuingUnit;

    /**
     * 接收单位
     */
    @Column(name = "accept_unit")
    @ApiModelProperty("接收单位")
    private String acceptUnit;

    /**
     * 发文日期
     */
    @Column(name = "issue_date")
    @ApiModelProperty("发文日期")
    private String issueDate;

    /**
     * 抄送单位
     */
    @Column(name = "copy_unit")
    @ApiModelProperty("抄送单位")
    private String copyUnit;

    /**
     * 发文单位
     */
    @Column(name = "issue_unit")
    @ApiModelProperty("发文单位")
    private String issueUnit;

    /**
     * 印发日期对应发文日期issueDate
     */
    @Column(name = "replica_date")
    @ApiModelProperty("印发日期对应发文日期issueDate")
    private String replicaDate;

    /**
     * 印发单位对应发文单位issueUnit
     */
    @Column(name = "replica_unit")
    @ApiModelProperty("印发单位对应发文单位issueUnit")
    private String replicaUnit;

    /**
     * 文件数量
     */
    @Column(name = "size")
    @ApiModelProperty("文件数量")
    private Long size;

    /**
     * 会议类型
     */
    @Column(name = "meeting_type")
    @ApiModelProperty("会议类型")
    private String meetingType;

    /**
     * 参会人员
     */
    @Column(name = "partici_pants")
    @ApiModelProperty("参会人员")
    private String particiPants;

    /**
     * 包括会议时间
     */
    @Column(name = "no_meeting_info")
    @ApiModelProperty("包括会议时间")
    private String noMeetingInfo;
}
