package com.tykj.forecast.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;

/**
 * 测试类
 *
 * @author mruny
 * @create 2022/6/17 14:44:40
 */
@Data
@NoArgsConstructor
@AllArgsConstructor

public class FileTestVo {

    /**
     * 文件名称
     */
    @Column(name = "custom_name")
    @ApiModelProperty("文件名称")
    private String customName;


    /**
     * 文件类型
     */
    @Column(name = "association_category")
    @ApiModelProperty("文件类型")
    private String associationCategory;

    /**
     * 文件类别{"规范性文件":0, "通报类文件":1, "议事协调机构类文件":2, "其他类":3}
     */
    @Column(name = "file_type")
    @ApiModelProperty("文件类别{规范性文件:0, 通报类文件:1, 议事协调机构类文件:2, 其他类:3}")
    private String fileType;

    /**
     * 发文字号
     */
    @Column(name = "issue_number")
    @ApiModelProperty("发文字号")
    private String issueNumber;

    /**
     * 版头发文单位
     */
    @Column(name = "front_issuing_unit")
    @ApiModelProperty("版头发文单位")
    private String frontIssuingUnit;

    /**
     * 签发人
     */
    @Column(name = "issue_person")
    @ApiModelProperty("签发人")
    private String issuePerson;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty("标题")
    private String title;

    /**
     * 主体发文单位
     */
    @Column(name = "body_issuing_unit")
    @ApiModelProperty("主体发文单位")
    private String bodyIssuingUnit;

    /**
     * 接收单位
     */
    @Column(name = "accept_unit")
    @ApiModelProperty("接收单位")
    private String acceptUnit;

    /**
     * 发文日期
     */
    @Column(name = "issue_date")
    @ApiModelProperty("发文日期")
    private String issueDate;

    /**
     * 抄送单位
     */
    @Column(name = "copy_unit")
    @ApiModelProperty("抄送单位")
    private String copyUnit;

    /**
     * 发文单位
     */
    @Column(name = "issue_unit")
    @ApiModelProperty("发文单位")
    private String issueUnit;

    /**
     * 印发日期对应发文日期issueDate
     */
    @Column(name = "replica_date")
    @ApiModelProperty("印发日期对应发文日期issueDate")
    private String replicaDate;

    /**
     * 印发单位对应发文单位issueUnit
     */
    @Column(name = "replica_unit")
    @ApiModelProperty("印发单位对应发文单位issueUnit")
    private String replicaUnit;

    /**
     * 文件数量
     */
    @Column(name = "size")
    @ApiModelProperty("文件数量")
    private Long size;


}
