package com.tykj.forecast.vo;

import com.tykj.forecast.entity.MeetingFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * 会议文件解析返回值
 *
 * @author mruny
 * @create 2022/6/13 14:53:53
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("会议公文分析json")
public class MeetingFileVo {

    /**
     * 文件标题
     */
    @ApiModelProperty("标题")
    private String fileTitle;

    /**
     * 文件名称
     */
    @ApiModelProperty("文件名称")
    private String customName;

    /**
     * 会议类型
     */
    @ApiModelProperty("会议类型")
    private String meetingType;

    /**
     * 参会人员
     */
    @ApiModelProperty("参会人员")
    private String particiPants;

    /**
     * 包括会议时间
     */
    @ApiModelProperty("包括会议时间")
    private String noMeetingInfo;

    /**
     * 文件数量
     */
    @ApiModelProperty("文件数量")
    private int size;

    public MeetingFile toMeetFile() {
        MeetingFile meetingFile = new MeetingFile();
        BeanUtils.copyProperties(this, meetingFile);
        return meetingFile;
    }
}
