package com.tykj.forecast.vo;

import com.tykj.forecast.entity.RetrenchFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * 精简公文类别
 *
 * @author mruny
 * @create 2022/6/13 14:57:24
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("精简公文类别")
public class RetrenchFileVo {

    /**
     * 文件标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 文件类别{"规范性文件":0, "通报类文件":1, "议事协调机构类文件":2, "其他类":3}
     */
    @ApiModelProperty("文件类别{规范性文件:0, 通报类文件:1, 议事协调机构类文件:2, 其他类:3}")
    private String fileType;

    /**
     * 文件名称
     */
    @ApiModelProperty("文件名称")
    private String customName;

    /**
     * 文件数量
     */
    @ApiModelProperty("文件数量")
    private int size;

    public RetrenchFile toRetrenchFile(){
        RetrenchFile retrenchFile = new RetrenchFile();
        BeanUtils.copyProperties(this,retrenchFile);
        return retrenchFile;
    }
}
