package com.git.mygitflow.config;

import com.google.common.base.Predicates;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    @Bean
    public Docket adminApiConfig() {
        // docket 摘要
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("测试")
                .apiInfo(adminApiInfo())
                .select() // 过滤器，用于实现对接口的分组，过滤掉不希望放在adminApi组的接口信息
                //只显示admin路径下的页面
                .paths(Predicates.or(PathSelectors.regex("/users.*"),PathSelectors.regex("/messages.*")))
                .build();
    }

    private ApiInfo adminApiInfo() {

        return new ApiInfoBuilder()
                .title("用户管理")
                .description("本文档描述了对用户的管理")
                .version("1.0")
                .contact(new Contact("MRY", "https://blog.csdn.net/qq_44786855?type=lately", "2779585601@qq.com"))
                .build();
    }
}