package com.git.mygitflow.controller;

import com.git.mygitflow.entity.Message;
import com.git.mygitflow.service.MessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/messages")
@Api(tags = "messages的CRUD")
public class MessageController {

    @Autowired
    private MessageService messageService;

    @GetMapping
    @ApiOperation(value = "查询所有")
    public ResponseEntity<List<Message>> find(){
        List<Message> result = messageService.find();
        if (result.size() == 0){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }
}
