package com.git.mygitflow.controller;

import com.git.mygitflow.entity.User;
import com.git.mygitflow.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/users")
@Api(tags = "用户的增删改查")
public class UserController {

    @Autowired
    private UserService userService;

    @GetMapping
    @ApiOperation(value = "查询所有")
    public ResponseEntity<List<User>> find(){
        List<User> result = userService.find();
        if (result.size() == 0) {
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @PostMapping
    @ApiOperation(value = "添加用户")
    public ResponseEntity<User> insert(@RequestBody User user){
        User result = userService.insert(user);
        if (result.getId() == 0 || result.getId() == null){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @PutMapping("/{id}")
    @ApiOperation(value = "修改用户")
    public ResponseEntity<User> update(@RequestBody User user){
        User result = userService.update(user);
        if (result.getId() == 0 || result.getId() == null){
            return ResponseEntity.status(404).body(result);
        }else {
            return ResponseEntity.ok(result);
        }
    }

    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除用户")
    public ResponseEntity<Integer> delete(@PathVariable Integer id){
        userService.delete(id);
        if (id == 0 || id ==null){
            return ResponseEntity.status(404).body(id);
        }else {
            return ResponseEntity.ok(id);
        }
    }
}
