package com.mry.utils;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/**
 * 解决耗时问题
 *
 * 第一次访问,getEntityManager方法，经过静态代码块创建一个factory对象，
 * 再调用方法创建一个EntityManager对象
 * 第二次访问,getEntityManager方法，直接通过一个已经创建好的factory对象，
 * 创建EntityManager对象
 */
public class JpaUtils {

    private static EntityManagerFactory factory;

    static {
        factory = Persistence.createEntityManagerFactory("myJpa");
    }

    /**
     * 获取EntityManager实体类对象
     */
    public static EntityManager getEntityManager(){
        return factory.createEntityManager();
    }
}
