package cn.itcast;

import cn.itcast.dao.UserDao;
import cn.itcast.entity.User;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:applicationContext.xml")
public class UserTest {

    @Autowired
    private UserDao userDao;

    /**
     * 保存用户: 调用调用save()方法
     */
    @Test
    public void testSave(){
        User user = new User();
        user.setId(1);
        user.setName("hahaha");
        userDao.save(user);
    }

    @Test
    public void testUpdate(){
        User user = new User();
        user.setId(4);
        user.setName("狗狗狗");
        user.setAge(18);
        user.setSex("男");
        userDao.save(user);
    }

    /**
     * 根据ID查询
     */
    @Test
    public void testFindOne(){
        User user = userDao.findOne(1);
        System.out.println(user);
    }

    /**
     * 删除
     */
    @Test
    public void testDelete(){
        userDao.delete(4);
    }

    /**
     * 测试统计查询
     */
    @Test
    public void testCount(){
        long count = userDao.count();
        System.out.println(count);
    }

    /**
     * 判断该id的可和是否存在
     *  1.如果为null不存在
     *  2.判断数据库中该ID的数量是否为0
     */
    @Test
    public void testExists(){
        boolean exists = userDao.exists(4);
        System.out.println(exists);
    }

    /**
     * 根据id从数据库查询
     * 懒加载,延迟加载
     */
    @Test
    @Transactional
    public void testGetOne(){
        User user = userDao.getOne(1);
        System.out.println(user);
    }

}
