package com.mry.pojo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;

/**
 * 客户的实体类
 *  需要配置映射关系
 *      1.实体类与表的映射关系
 *      2.实体类中属性与表中字段的映射关系
 * @Entity：声明实体类
 * @Table：配置实体类和表的映射关系
 *      name: 配置数据库表的名称
 * 2.实体类中属性与表中字段之间的关系
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@Entity
@Table(name = "jpa")
public class User {
    /**
     * @id：声明主键的配置
     * @GeneratedValue：配置主键的生成策略
     *      GenerationType.IDENTITY：自增(底层数据库支持的自动增长方式，对id自增)mysql
     *      GenerationType.SEQUENCE：序列(底层数据库必须支持序列)oracle
     *      GenerationType.TABLE：JPA机制，通过一张数据库表的形式帮助我们完成主键自增
     *      GenerationType.AUTO：程序自动的帮我们选择主键自增策略
     * @Column：配置属性和字段的映射关系
     *      name: 数据库表中字段的名称
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id; //客户主键ID
    @Column(name = "name")
    private String name;//姓名
    @Column(name = "age")
    private Integer age;//年龄
    @Column(name = "sex")
    private String sex;//性别


}
