package com.mry;

import com.mry.pojo.User;
import com.mry.utils.JpaUtils;
import org.junit.Test;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class JpaTest {
    /**
     * 测试JPA的保存
     *      案例：保存一个客户到数据库中
     * JPA的操作步骤：
     *      1.加载配置文件创建工厂(实体管理类工厂)对象
     *      2.通过实体管理类工厂获取实体管理器
     *      3***.获取事务对象，开启事务
     *      4.完成增删改查操作
     *      5.提交事务(回滚事务)
     *      6.释放资源
     */
    @Test
    public void testSave(){
//        //1.加载配置文件
//        EntityManagerFactory factory =
//                Persistence.createEntityManagerFactory("myJpa");
//        //2.获取实体管理器
//        EntityManager em = factory.createEntityManager();
        EntityManager em = JpaUtils.getEntityManager();
        //3.获取事务
        EntityTransaction tx = em.getTransaction();//获取事务对象
        tx.begin();//开启事务
        //4.完成增删改查操作，保存一个客户到数据库中
        User user = new User();
        user.setName("滴滴滴");
        user.setAge(123);
        user.setSex("男");
        em.persist(user);//保存操作
        //5.提交事务
        tx.commit();
        //6.释放资源
        em.close();
//        factory.close();
    }

    /**
     * find方法查询，
     *      1.查询的对象就是当前的客户对象本身
     *      2.在调用find方法的时候，就发送SQL语句查询数据库
     */
    @Test
    public void testFind(){
        //1.通过工具类获取EntityManager
        EntityManager em = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction et = em.getTransaction();
        et.begin();
        //3.CRUD
        /**
         * find：根据id查询数据
         *      class:查询数据的结果需要包装的实体类类型的字节码
         *      id: 查询的主键的取值
         * 立即加载：
         */
        User user = em.find(User.class, 1);
//        System.out.println(user);
        //提交事务
        et.commit();
        //释放资源
        em.close();
    }

    /**
     * getReference方法:
     *      1.获取的对象是一个动态代理对象
     *      2.使用getReference方法不会立即发送sql语句查询数据库
     *          当调用查询结果对象的时候，才会发送查询的sql语句
     *          什么时候用，什么时候发送
     * 延迟加载(懒加载)
     *      得到的是一个动态代理对象
     *      什么时候用，什么时候才会查询
     *  一般使用延迟加载
     */
    @Test
    public void testReference(){
        //1.加载配置文件获取管理器
        EntityManager em = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction et = em.getTransaction();
        et.begin();
        //3.业务逻辑
        User user = em.getReference(User.class,1);
//        System.out.println(user);
        //4.提交事务
        et.commit();
        //5.释放缓存
        em.close();
    }

    @Test
    public void testRemove(){
        //1.加载配置文件获取管理器
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.业务CRUD
            //3.1根据ID查询客户，然后删除
        User user = entityManager.find(User.class,1);
        entityManager.remove(user);
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    @Test
    public void testUpdate(){
        //1.获取配置文件，获取管理器
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.业务CRUD，更新操作
        User user = entityManager.getReference(User.class, 1);
        user.setName("张三");
        entityManager.merge(user);
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

}
