package cn.itcast.domain;

import lombok.*;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="cst_customer")
@Getter
@Setter
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class Customer {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="cust_id")
    private Long custId;
    @Column(name="cust_address")
    private String custAddress;
    @Column(name="cust_industry")
    private String custIndustry;
    @Column(name="cust_level")
    private String custLevel;
    @Column(name="cust_name")
    private String custName;
    @Column(name="cust_phone")
    private String custPhone;
    @Column(name="cust_source")
    private String custSource;

    //配置客户和联系人之间的关系(一对多)
    //使用注解形式配置多表关系
    /**
     * 1.声明关系
     * @OneToMany 配置一堆多关系
     *         targetEntity: 对方对象的字节码对象
     * 2.配置外键(中间表)
     * @JoinColumn 配置外检
     *          name: 外检字段名称
     *          referencedColumnName: 参照的主表的主字段名称
     *
     *  在客户实体类上(一的一方) 添加了外检配置，所以对可和而言也具备了维护外键的作用
     */

    /**
     * cascade: 配置级联    (可以配置到设置多表的映射关系的注解上)
     *      CascadeType.ALL         :所有
     *                  MERGE       :更新
     *                  PERSIST     :保存
     *                  REMOVE      :删除
     *  虽然可以配置但是不推荐使用
     * fetch: 配置关联对象的加载方式
     *          EAGER: 立即加载
     *          LAZY: 延迟加载(默认的)
     */
    //@OneToMany(targetEntity = LinkMan.class)//对方实体类的类型
    //@JoinColumn(name = "lkm_cust_id",referencedColumnName = "cust_id")
    //放弃维护权               对方控制权限的属性名称
    @OneToMany(mappedBy = "customer",cascade = CascadeType.ALL)
    private Set<LinkMan> linkMans = new HashSet<LinkMan>();

    @Override
    public String toString() {
        return "Customer{" +
                "custId=" + custId +
                ", custAddress='" + custAddress + '\'' +
                ", custIndustry='" + custIndustry + '\'' +
                ", custLevel='" + custLevel + '\'' +
                ", custName='" + custName + '\'' +
                ", custPhone='" + custPhone + '\'' +
                ", custSource='" + custSource + '\'' +
                '}';
    }
}
