package cn.itcast;

import cn.itcast.dao.UserDao;
import cn.itcast.entity.User;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:applicationContext.xml")
public class JpqlTest {

    @Autowired
    private UserDao userDao;

    @Test
    public void findJpql(){
        User user = userDao.findJpql("李四");
        System.out.println(user);
    }

    /**
     *
     */
    @Test
    public void findUserNameAndId(){
        User user = userDao.findUserNameAndId("李四",2);
        System.out.println(user);
    }

    /**
     * 1.更新删除操作，需要手动添加事务
     * 2.默认会执行结束之后回滚事务
     * @Rollback 是否自动回滚,false不会滚，true需要回滚(默认的)
     */
    @Test
    @Transactional
    @Rollback(value = false)//不要自动回滚
    public void updateUser(){
        userDao.updateUser("张三","男",5);
    }

    @Test
    public void findSql(){
        List<User> list = userDao.findSql();
        for (Object obj : list){
            System.out.println(obj);
        }
    }

    @Test
    public void findSql1(){
        List<User> list = userDao.findSql1("张%");
        for (Object obj : list){
            System.out.println(obj);
        }
    }

    @Test
    public void testNaming(){
        User user = userDao.findByName("张三");
        System.out.println(user);
    }

    @Test
    public void testNameAgeSex(){
        User user = userDao.findByNameAndAgeAndSex("张三", 20, "男");
        System.out.println(user);
    }

    @Test
    public void testFindByNameLike(){
        List<User> list = userDao.findByNameLike("张%");
        for (Object obj : list){
            System.out.println(obj);
        }
    }

    @Test
    public void findByNameLikeAndAge(){
        List<User> list = userDao.findByNameLikeAndAge("张%", 20);
        for (Object obj : list){
            System.out.println(obj);
        }
    }
}
