package cn.itcas.test;

import cn.itcast.dao.RoleDao;
import cn.itcast.dao.UserDao;
import cn.itcast.domain.Role;
import cn.itcast.domain.User;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:applicationContext.xml")
public class ManyToManyTest {

    @Autowired
    private UserDao userDao;

    @Autowired
    private RoleDao roleDao;

    /**
     * 保存一个用户，保存一个角色
     *
     *  多堆垛放弃维护全，被动的一方放弃
     */
    @Test
    @Transactional
    @Rollback(value = false)
    public void testAdd(){
        User user = new User();
        user.setUserName("小李");
        Role role = new Role();
        role.setRoleName("小王");

        //配置用户到角色的关系，可以对中间表中的数据进行维护 1-1
        user.getRoles().add(role);

        //配置角色到用户的关系，可以对中间表中的数据进行维护 1-1
        role.getUsers().add(user);

        userDao.save(user);
        roleDao.save(role);

    }

    /**
     * 测试保存一个用户的同事保存关联的关联的角色
     */
    @Test
    @Transactional
    @Rollback(value = false)
    public void testCasCadeAdd(){
        User user = new User();
        user.setUserName("小李");
        Role role = new Role();
        role.setRoleName("小王");

        //配置用户到角色的关系，可以对中间表中的数据进行维护 1-1
        user.getRoles().add(role);

        //配置角色到用户的关系，可以对中间表中的数据进行维护 1-1
        role.getUsers().add(user);

        userDao.save(user);
    }

    /**
     * 删除id为1的用户，同事删除他的关联对象，中间表的数据也删除
     */
    @Test
    @Transactional
    @Rollback(value = false)
    public void testCasCadeRemove(){
        User user = userDao.findOne(1l);
        userDao.delete(user);

    }


}
