package com.jpa.jpaspringboot.service.Impl;

import com.jpa.jpaspringboot.dao.UserDao;
import com.jpa.jpaspringboot.entity.User;
import com.jpa.jpaspringboot.service.UserService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    private final UserDao userDao;

    public UserServiceImpl(UserDao userDao) {
        this.userDao = userDao;
    }


    @Override
    public List<User> find() {
        return userDao.findAll();
    }

    @Override
    public User insert(User user) {
        return userDao.save(user);
    }

    @Override
    public User delete(User user) {
        userDao.deleteById(user.getId());
        return user;
    }

    @Override
    public User update(User user) {
        userDao.findById(user.getId());
        userDao.save(user);
        return user;
    }


}
