package com.mry;

import com.mry.utils.JpaUtils;
import org.junit.Test;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import java.util.List;

/**
 * jpql语句
 *      1.创建query查询对象
  *      2.对象参数进行赋值
 *      3.查询，并且得到返回结果
 */
public class JpqlTest {
    /**
     * 查询全部
     *      jpql: from com.mry.pojo.User
     *      sql: SELECT * FROM jpa
     */
    @Test
    public void testFindAll(){
        //1.获取EntityManager对象
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.CRUD操作
        String jpql = "FROM User";
            //创建Query查询对象，query对象才是执行jpql的对象
        Query query = entityManager.createQuery(jpql);
            //发送查询，并且封装结果集
        List list = query.getResultList();
        for(Object obj : list){
            System.out.println(obj);
        }
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    /**
     * 排序查询:
     *      sql: SELECT * FROM jpa ORDER BY id desc
     *      jpql: from User order by desc
     */
    @Test
    public void testOrders() {
        //1.获取EntityManager对象
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.CRUD操作
        String jpql = "from User order by id desc";
        //创建Query查询对象，query对象才是执行jpql的对象
        Query query = entityManager.createQuery(jpql);
        //发送查询，并且封装结果集
        List list = query.getResultList();
        for(Object obj : list){
            System.out.println(obj);
        }
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    /**
     * 统计人数
     *      sql: SELECT COUNT(id) FROM jpa
     *      jpql: SELECT COUNT(id) FROM User
     */
    @Test
    public void testCount() {
        //1.获取EntityManager对象
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.CRUD操作
        String jpql = "SELECT COUNT(id) FROM User";
            //1.创建Query查询对象，query对象才是执行jpql的对象
        Query query = entityManager.createQuery(jpql);
        //发送查询，并且封装结果集
        Object o = query.getSingleResult();
        System.out.println(o);
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    /**
     * 分页查询:
     *      sql: select * from jpa limit ?,?
     *      jpql: from User
     */
    @Test
    public void testPaged() {
        //1.获取EntityManager对象
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.CRUD操作
        String jpql = "from User";
        //3.1.创建Query查询对象，query对象才是执行jpql的对象
        Query query = entityManager.createQuery(jpql);
        //3.2对参数赋值
        //起始索引
        query.setFirstResult(0);
        //每页查询条数
        query.setMaxResults(4);
        //发送查询，并且封装结果集
        List list = query.getResultList();
        for (Object o : list){
            System.out.println(o);
        }
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    /**
     * 条件查询:
     *      sql: select * from jpa where name like '张%'
     *      jpql: from User where name like ?
     */
    @Test
    public void testCondition() {
        //1.获取EntityManager对象
        EntityManager entityManager = JpaUtils.getEntityManager();
        //2.开启事务
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        //3.CRUD操作
        String jpql = "from User where name like ?";
        //3.1创建Query对象
        Query query = entityManager.createQuery(jpql);
        //3.2query进行赋值
        //第一个参数，占位符的索引位置
        query.setParameter(1,"张%");
        List list = query.getResultList();
        for (Object o : list){
            System.out.println(o);
        }
        //4.提交事务
        transaction.commit();
        //5.释放资源
        entityManager.close();
    }

    @Test
    public void test(){
        EntityManager entityManager = JpaUtils.getEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();


        transaction.commit();
        entityManager.close();
    }

}
