package org.matrix.autotest.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "动态变量表")
@TableName(value = "dynamic_variable")
public class DynamicVariable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 所属项目
     */
    @ApiModelProperty(value = "所属项目")
    private Integer projectId;

    /**
     * 取用字段
     */
    @ApiModelProperty(value = "取用字段")
    private String takenField;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP
     */
    @ApiModelProperty(value = "动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP")
    private Integer type;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 详细内容
     */
    @ApiModelProperty(value = "详细内容")
    private String detail;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;


}
