package org.matrix.autotest.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "用例表")
@TableName(value = "test_case")
public class TestCase {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 所属项目
     */
    @ApiModelProperty(value = "所属项目")
    private Integer projectId;

    /**
     * 用例类型 1为http
     */
    @ApiModelProperty(value = "用例类型 1为http")
    private Integer type;

    /**
     * 前置行动ID组，例如：1，2，3
     */
    @ApiModelProperty(value = "前置行动ID组，例如：1，2，3")
    private String moveBefore;

    /**
     * 后置行动ID组，例如：1，2，3
     */
    @ApiModelProperty(value = "后置行动ID组，例如：1，2，3")
    private String moveAfterCase;

    /**
     * 测试执行后行动ID组，例如：1，2，3
     */
    @ApiModelProperty(value = "测试执行后行动ID组，例如：1，2，3")
    private String moveAfterTest;

    /**
     * 是否进行异常检验,0为否,1为是
     */
    @ApiModelProperty(value = "是否进行异常检验,0为否,1为是")
    private Integer abnormalCheckpoint;

    /**
     * 是否进行非空检验,0为否,1为是
     */
    @ApiModelProperty(value = "是否进行非空检验,0为否,1为是")
    private Integer noEmptyCheckpoint;

    /**
     * 包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四
     */
    @ApiModelProperty(value = "包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四")
    private String containCheckpoint;

    /**
     * 不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四
     */
    @ApiModelProperty(value = "不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四")
    private String noContainCheckpoint;

    /**
     * jsonpath检验点，以json形式存放
     */
    @ApiModelProperty(value = "jsonpath检验点，以json形式存放")
    private String jsonpathCheckpoint;

    /**
     * 详细参数
     */
    @ApiModelProperty(value = "详细参数")
    private String detail;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;


}
