package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Connect;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface ConnectService extends IService<Connect> {
    /**
     * 查询所有连接池
     *
     * @return 查询到的所有连接池
     */
    List<Connect> findAllConnect();

    /**
     * 根据id查询连接池
     *
     * @param id 连接池Id
     * @return 连接池
     */
    Connect findByIdConnect(Integer id);

    /**
     * 添加连接池
     *
     * @param connect 连接池
     * @return 影响行数
     */
    int insertConnect(Connect connect);

    /**
     * 修改连接池
     *
     * @param connect 连接池
     * @return 影响行数
     */
    int updateConnect(Connect connect);

    /**
     * 删除连接池
     *
     * @param id 连接池id
     * @return 影响行数
     */
    int deleteConnect(Integer id);

}
