package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Move;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface MoveService extends IService<Move> {
    /**
     * 查询所有行为
     *
     * @return 查询到的所有行为
     */
    List<Move> findAllMove();

    /**
     * 根据id查询行为
     *
     * @param id 行为id
     * @return 行为
     */
    Move findByIdMove(Integer id);

    /**
     * 添加行为
     *
     * @param move 行为
     * @return 影响行数
     */
    int insertMove(Move move);

    /**
     * 修改行为
     *
     * @param move 行为
     * @return 影响行数
     */
    int updateMove(Move move);

    /**
     * 删除行为
     *
     * @param id 行为id
     * @return 影响行数
     */
    int deleteMove(Integer id);

    /**
     * 根据项目id查询动作
     *
     * @param projectId 项目id
     * @return 符合项目id的动作
     */
    List<Move> findByProjectIdMove(Integer projectId);

}
