## 创建远程仓库

首先需在 github 中创建 repo：
![image.png](https://git.yfzx.zjtys.com.cn/npl/simple-springboot-project/raw/master/README.assets/1630982391285-f6d46a35-b2c5-40e5-8e46-0cfbbbbab8cd.png)

## 远程仓库操作
| **命令**                             | **作用**                                         |
| ------------------------------------ | ------------------------------------------------ |
| `git remote -v`                      | 查看当前所有远程地址别名                         |
| `git remote add 别名 远程地址`       | 给远程地址起别名                                 |
| `git remote rm 别名`                 | 移除已设置的别名                                 |
| `git push 别名 分支`                 | 推送当前分支上的内容到远程仓库                   |
| `git clone 远程地址`                 | 将远程仓库的内容克隆到本地                       |
| `git pull 远程库地址别名 远程分支名` | 将远程仓库指定分支最新内容拉下来后与当前分支合并 |

### 给远程地址起别名
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630982638581-2ef4ae8f-dbf2-49d8-9211-be0ce7401b48-1631244609575.png)
### 查看当前所有远程地址别名
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630982664262-bf628fb6-2f0a-49e3-94aa-d9f95d8e1dfd.png)
### 推送当前分支上的内容到远程仓库
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630983069038-5a183ef2-2e58-4d09-9400-b791a1e54c83.png)
推送完成后，在 github 的对应仓库会看到新增了一条名为 master 的分支，在该分支下有一个 hello.txt 文件：
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630983142258-ce8af206-f4c5-404d-b2af-db02e4d6d8ae.png)

### 将远程仓库的内容克隆到本地
clone 会进行以下操作：1）拉去代码；2）初始化本地仓库；3）创建别名


在本地新建文件夹，进入该文件夹，右键 `Git Bash Here`，输入以下命令，clone 指定分支的内容：
```shell
git clone -b master https://github.com/tyshaokr/git-demo.git
```
通过这种方式，可以将 master 分支下的内容 clone 到本地库中。


clone 结果如下所示：
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630985555498-3723ceed-f8c6-4dad-867a-5647704ae4e2.png)

### 将远程仓库指定分支最新内容拉下来后与当前分支合并

在 github 中修改 hello.txt 文件，内容变为如下：
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630984448096-fbc9ed00-3620-4ca8-965f-81941a17dce8.png)
在 master 分支下，拉取远程仓库 master 分支下的内容：
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630984026183-e50d2e37-ec9c-44b2-94a1-60bdaa3ac26a.png)
查看 master 分支下的 hello.txt：
![image.png](C:\Users\AI_Future\Desktop\simple-springboot-project\README.assets\1630984485659-60afcc33-0588-47e1-9954-94503e871198.png)