package com.ai.controller;

import com.ai.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@CrossOrigin
@RequestMapping("/user")
public class UserController {

    @Autowired
    private UserService userService;

    /**
     * 查询所有用户信息
     * @return
     * http://localhost:8081/user
     */
    //
    @GetMapping
    public String findAllUser() {
        return userService.findAllUser().toString();
    }

    /**
     * 查询指定id的用户
     * @param id
     * @return
     */
    // http://localhost:8081/user/1
    @GetMapping("/{id}")
    public String findUserById(@PathVariable Long id){
        return userService.findUserById(id).toString();
    }

}
